<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $page_type = $_POST['page_type'] ?? '';
    $page = $_POST['page'] ?? '';
    $title = $_POST['title'] ?? '';
    $description = $_POST['description'] ?? '';
    $keywords = $_POST['keywords'] ?? '';
    $image = null;

    // رفع الصورة
    if (!empty($_FILES['image']['name'])) {
        $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        $image = uniqid() . '.' . $ext;
        move_uploaded_file($_FILES['image']['tmp_name'], '../../uploads/seo/' . $image);
    }

    $stmt = $pdo->prepare("INSERT INTO seo_pages (page_type, page, title, description, keywords, custom_title, custom_description, custom_image) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$page_type, $page, $title, $description, $keywords, $title, $description, $image]);

    header("Location: index.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>إضافة صفحة SEO</title>
  <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
  <style>
    body {
      font-family: 'Cairo', sans-serif;
      background-color: #f9f9f9;
      padding: 40px;
    }
    .form-container {
      background: #fff;
      max-width: 700px;
      margin: auto;
      padding: 30px;
      border-radius: 12px;
      box-shadow: 0 4px 15px #e7e7e7;
    }
    h2 {
      text-align: center;
      color: #3e165a;
      margin-bottom: 30px;
    }
    label {
      display: block;
      margin-bottom: 6px;
      font-weight: 600;
      color: #444;
    }
    input[type="text"],
    textarea,
    select {
      width: 100%;
      padding: 10px;
      margin-bottom: 20px;
      border-radius: 8px;
      border: 1px solid #ccc;
      font-size: 15px;
    }
    input[type="file"] {
      margin-bottom: 20px;
    }
    button {
      background-color: #7c3aed;
      color: #fff;
      padding: 12px 25px;
      border: none;
      border-radius: 8px;
      font-size: 16px;
      cursor: pointer;
      transition: 0.2s;
    }
    button:hover {
      background-color: #3e165a;
    }
    .home-btn {
      background: linear-gradient(135deg, #3e165a 60%, #7c3aed 100%);
      color: #fff;
      padding: 10px 20px;
      border-radius: 30px;
      text-decoration: none;
      display: inline-flex;
      align-items: center;
      margin-bottom: 25px;
      font-weight: bold;
    }
    .home-btn i {
      margin-left: 8px;
    }
  </style>
</head>
<body>

<div class="form-container">
  <a href="index.php" class="home-btn"><i class="fa fa-arrow-right"></i> الرئيسية</a>

  <h2>إضافة إعدادات SEO</h2>
  <form method="POST" enctype="multipart/form-data">
    <label for="page_type">نوع الصفحة</label>
    <select name="page_type" id="page_type" required>
      <option value="">اختر نوع الصفحة</option>
      <option value="static">ثابتة</option>
      <option value="dynamic">ديناميكية</option>
    </select>

    <label for="page">الرابط</label>
    <input type="text" name="page" id="page" placeholder="مثال: about.php" required>

    <label for="title">عنوان الصفحة</label>
    <input type="text" name="title" id="title" required>

    <label for="description">وصف الصفحة</label>
    <textarea name="description" id="description" rows="4" required></textarea>

    <label for="keywords">الكلمات الدلالية (مفصولة بفاصلة)</label>
    <input type="text" name="keywords" id="keywords" placeholder="كلمة, كلمة أخرى, ...">

    <label for="image">صورة OG (اختياري)</label>
    <input type="file" name="image" id="image" accept="image/*">

    <button type="submit">حفظ</button>
  </form>
</div>

</body>
</html>
