<?php
require_once("../../config/db.php");

// عند إرسال النموذج
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $title = $_POST['title'] ?? '';
    $category = $_POST['category'] ?? '';
    $content = $_POST['content'] ?? '';
    $created_at = date('Y-m-d H:i:s');

    // التعامل مع رفع الصورة
    $image_path = '';
    if (!empty($_FILES['image']['name'])) {
        $upload_dir = "../../uploads/";
        $filename = time() . '_' . basename($_FILES['image']['name']);
        $target_path = $upload_dir . $filename;

        if (move_uploaded_file($_FILES['image']['tmp_name'], $target_path)) {
            $image_path = "uploads/" . $filename;
        }
    }

    // إدخال البيانات
    $stmt = $pdo->prepare("INSERT INTO posts (title, category, content, image, created_at) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$title, $category, $content, $image_path, $created_at]);

    header("Location: index.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>إضافة مقال</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            background: #f8f9fa;
            font-family: 'Cairo', sans-serif;
            margin: 0;
            color: #2e2340;
        }
        .container {
            max-width: 700px;
            margin: 45px auto;
            background: #fff;
            padding: 30px;
            border-radius: 14px;
            box-shadow: 0 0 20px rgba(0,0,0,0.05);
        }
        h1 {
            text-align: center;
            margin-bottom: 30px;
            color: #3e165a;
        }
        label {
            display: block;
            margin-top: 15px;
            margin-bottom: 5px;
            font-weight: 600;
        }
        input[type="text"],
        textarea,
        input[type="file"] {
            width: 100%;
            padding: 10px;
            border-radius: 7px;
            border: 1px solid #ccc;
            font-size: 15px;
        }
        textarea {
            min-height: 150px;
        }
        button {
            margin-top: 20px;
            padding: 12px 28px;
            font-size: 16px;
            border: none;
            background: linear-gradient(135deg, #7c3aed, #3e165a);
            color: #fff;
            border-radius: 30px;
            cursor: pointer;
            display: block;
            width: 100%;
        }
        button:hover {
            background: linear-gradient(135deg, #3e165a, #7c3aed);
        }
        .back-btn {
            display: inline-block;
            margin-bottom: 20px;
            text-decoration: none;
            background: #e4def5;
            color: #3e165a;
            padding: 8px 16px;
            border-radius: 8px;
            font-weight: bold;
        }
    </style>
</head>
<body>
<div class="container">
    <a class="back-btn" href="index.php"><i class="fa fa-arrow-right"></i> الرجوع للمقالات</a>
    <h1><i class="fa fa-plus"></i> إضافة مقال جديد</h1>
    <form action="" method="POST" enctype="multipart/form-data">
        <label for="title">عنوان المقال</label>
        <input type="text" name="title" id="title" required>

        <label for="category">التصنيف</label>
        <input type="text" name="category" id="category" required>

        <label for="image">صورة المقال (اختياري)</label>
        <input type="file" name="image" id="image" accept="image/*">

        <label for="content">المحتوى</label>
        <textarea name="content" id="content" required></textarea>

        <button type="submit"><i class="fa fa-save"></i> حفظ المقال</button>
    </form>
</div>
</body>
</html>
