<?php
require_once "../includes/auth.php";
require_once "../config/db.php";
$stmt = $pdo->query("SELECT * FROM partners ORDER BY id DESC");
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>شركاء النجاح</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            background: #f8f9fa;
            font-family: 'Cairo', sans-serif;
            color: #2e2340;
            margin: 0;
        }
        .container {
            max-width: 800px;
            margin: 45px auto 0 auto;
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 7px 30px #e6e6e6;
            padding: 38px 24px 25px 24px;
            min-height: 320px;
        }
        .header-bar {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 32px;
        }
        .header-bar h2 {
            color: #3e165a;
            font-size: 1.7rem;
            font-weight: 800;
            margin: 0;
        }
        .home-btn {
            background: linear-gradient(135deg, #3e165a 60%, #7c3aed 100%);
            color: #fff;
            padding: 8px 24px 8px 18px;
            border-radius: 50px;
            border: none;
            font-size: 1rem;
            font-weight: 700;
            cursor: pointer;
            display: flex;
            align-items: center;
            transition: background 0.2s, box-shadow 0.2s;
            box-shadow: 0 3px 15px rgba(62,22,90,0.09);
            text-decoration: none !important;
        }
        .home-btn i {
            margin-left: 10px;
            font-size: 1.2em;
        }
        .home-btn:hover {
            background: linear-gradient(135deg, #7c3aed, #3e165a);
        }
        .add-btn {
            background: #7c3aed;
            color: #fff !important;
            padding: 7px 19px 7px 16px;
            border-radius: 25px;
            font-size: 1rem;
            font-weight: 700;
            border: none;
            margin-bottom: 14px;
            display: inline-flex;
            align-items: center;
            transition: background 0.17s;
            text-decoration: none !important;
            box-shadow: 0 2px 10px #e7e2fa9e;
        }
        .add-btn i {
            margin-left: 7px;
        }
        .add-btn:hover {
            background: #3e165a;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 14px;
            background: #fff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 1px 9px #ece1fd3a;
            font-size: 1rem;
        }
        th, td {
            padding: 13px 7px;
            text-align: center;
        }
        th {
            background: linear-gradient(135deg, #3e165a 80%, #7c3aed 100%);
            color: #fff;
            font-size: 1.05rem;
            font-weight: 700;
            border-bottom: 2px solid #eee;
        }
        tr:nth-child(even) td {
            background: #f5f4fa;
        }
        tr:nth-child(odd) td {
            background: #fff;
        }
        td {
            color: #40215b;
            border-bottom: 1px solid #eee;
            vertical-align: middle;
        }
        .partner-logo {
            width: 60px;
            height: 38px;
            object-fit: contain;
            border-radius: 9px;
            box-shadow: 0 1px 7px #eaeaea;
            background: #fafafd;
        }
        .action-links a {
            color: #7c3aed;
            font-weight: 700;
            margin: 0 5px;
            padding: 4px 10px;
            border-radius: 7px;
            transition: background 0.13s, color 0.12s;
            text-decoration: none !important;
            font-size: 14px;
            border: 1px solid #f0eafd;
        }
        .action-links a:hover {
            background: #7c3aed;
            color: #fff !important;
        }
        .action-links a.delete {
            color: #e74c3c;
            border-color: #ffebeb;
        }
        .action-links a.delete:hover {
            background: #e74c3c;
            color: #fff !important;
        }
        @media (max-width: 600px) {
            .container { padding: 12px 2vw; }
            table, thead, tbody, th, td, tr { font-size: 13px; }
            .header-bar h2 { font-size: 1.02rem; }
            .home-btn, .add-btn { padding: 5px 10px 5px 7px; font-size: 12px; }
            .partner-logo { width: 36px; height: 24px; }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header-bar">
            <h2><i class="fa fa-handshake" style="color:#7c3aed; margin-left:7px;"></i> شعارات الشركاء</h2>
            <a href="index.php" class="home-btn"><i class="fa fa-home"></i> الرئيسية</a>
        </div>
        <a href="partner_add.php" class="add-btn"><i class="fa fa-plus"></i> إضافة شريك</a>
        <table>
            <thead>
                <tr>
                    <th>الشعار</th>
                    <th>الاسم</th>
                    <th>الرابط</th>
                    <th>تحكم</th>
                </tr>
            </thead>
            <tbody>
<?php foreach($stmt as $p): ?>
    <tr>
        <td>
            <?php
            $logo_file = $p['logo'] ?? '';
            $logo_path = __DIR__ . '/../uploads/partners/' . $logo_file;
            if (!empty($logo_file) && file_exists($logo_path)): ?>
                <img src="../uploads/partners/<?= htmlspecialchars($p['logo']) ?>" class="partner-logo" alt="شعار">
            <?php else: ?>
                <span style="color:#bbb;">لا يوجد شعار</span>
            <?php endif; ?>
        </td>
        <td><?= htmlspecialchars($p['name'] ?? '') ?></td>
        <td>
            <?php if (isset($p['link']) && trim($p['link']) !== ''): ?>
                <a href="<?= htmlspecialchars($p['link']) ?>" target="_blank"><?= htmlspecialchars($p['link']) ?></a>
            <?php else: ?>
                <span style="color:#bbb;">لا يوجد</span>
            <?php endif; ?>
        </td>
        <td class="action-links">
            <a href="partner_edit.php?id=<?= $p['id'] ?>"><i class="fa fa-edit"></i> تعديل</a>
            <a href="partner_delete.php?id=<?= $p['id'] ?>" class="delete" onclick="return confirm('تأكيد الحذف؟')"><i class="fa fa-trash"></i> حذف</a>
        </td>
    </tr>
<?php endforeach; ?>


            </tbody>
        </table>
    </div>
</body>
</html>
