<?php
require_once "../includes/auth.php";
require_once "../config/db.php";

// جلب بيانات الشريك
$id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$stmt = $pdo->prepare("SELECT * FROM partners WHERE id=?");
$stmt->execute([$id]);
$partner = $stmt->fetch();

if (!$partner) {
    die("لم يتم العثور على الشريك المطلوب.");
}

// عند إرسال النموذج
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $link = trim($_POST['link']);
    $logo = $partner['logo']; // افتراضي: الشعار القديم

    // إذا تم رفع شعار جديد
    if (!empty($_FILES['logo']['name'])) {
        $ext = strtolower(pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION));
        $newLogo = 'partner_' . time() . '.' . $ext;
        $dest = __DIR__ . '/../uploads/partners/' . $newLogo;
        if (move_uploaded_file($_FILES['logo']['tmp_name'], $dest)) {
            // حذف الشعار القديم إن وجد
            if (!empty($logo) && file_exists(__DIR__ . '/../uploads/partners/' . $logo)) {
                @unlink(__DIR__ . '/../uploads/partners/' . $logo);
            }
            $logo = $newLogo;
        }
    }

    // تحديث البيانات
    $stmt = $pdo->prepare("UPDATE partners SET name=?, link=?, logo=? WHERE id=?");
    $stmt->execute([$name, $link, $logo, $id]);

    header("Location: partners.php?msg=updated");
    exit;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تعديل شريك</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            background: #f8f9fa;
            font-family: 'Cairo', sans-serif;
            color: #2e2340;
            margin: 0;
        }
        .container {
            max-width: 440px;
            margin: 55px auto 0 auto;
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 7px 30px #e6e6e6;
            padding: 38px 30px 25px 30px;
        }
        h2 {
            text-align: center;
            color: #7c3aed;
            font-weight: 800;
            margin-bottom: 28px;
            font-size: 1.3rem;
        }
        .form-group {
            margin-bottom: 22px;
        }
        label {
            font-weight: 600;
            color: #40215b;
            display: block;
            margin-bottom: 7px;
        }
        input[type="text"], input[type="url"], input[type="file"] {
            width: 100%;
            padding: 11px;
            border: 1.4px solid #e8e3fa;
            border-radius: 7px;
            background: #fcfbff;
            font-family: 'Cairo', sans-serif;
            font-size: 1rem;
            margin-bottom: 4px;
        }
        input[type="file"] {
            padding: 6px 2px;
            background: #fff;
            border: none;
        }
        .current-logo {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-top: 7px;
            margin-bottom: 12px;
        }
        .current-logo img {
            width: 74px;
            height: 44px;
            object-fit: contain;
            border-radius: 10px;
            background: #fafafd;
            box-shadow: 0 1px 7px #eaeaea;
        }
        .btn-main {
            background: linear-gradient(135deg, #7c3aed, #3e165a);
            color: #fff;
            padding: 12px 0;
            border: none;
            border-radius: 7px;
            font-size: 1rem;
            font-weight: 700;
            cursor: pointer;
            transition: background 0.17s, box-shadow 0.16s;
            box-shadow: 0 2px 9px #e8e1fa77;
            margin-top: 12px;
            width: 100%;
        }
        .btn-main:hover {
            background: linear-gradient(135deg, #3e165a, #7c3aed);
        }
        .back-btn {
            display: inline-block;
            margin-top: 19px;
            color: #7c3aed;
            font-weight: 600;
            text-align: center;
            width: 100%;
            text-decoration: none;
            font-size: 15px;
            padding: 7px 0;
            border-radius: 6px;
            transition: background 0.13s;
        }
        .back-btn:hover {
            background: #f6efff;
            color: #3e165a;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2><i class="fa fa-user-edit"></i> تعديل شريك</h2>
        <form method="post" enctype="multipart/form-data">
            <div class="form-group">
                <label>اسم الشريك</label>
                <input type="text" name="name" required value="<?= htmlspecialchars($partner['name'] ?? '') ?>">
            </div>
            <div class="form-group">
                <label>الرابط</label>
                <input type="url" name="link" placeholder="https://example.com"
                    value="<?= isset($partner['link']) ? htmlspecialchars(trim($partner['link'])) : '' ?>">
            </div>
            <div class="form-group">
                <label>الشعار الحالي</label>
                <div class="current-logo">
                    <?php if (!empty($partner['logo']) && file_exists(__DIR__ . '/../uploads/partners/' . $partner['logo'])): ?>
                        <img src="../uploads/partners/<?= htmlspecialchars($partner['logo']) ?>" alt="الشعار الحالي">
                    <?php else: ?>
                        <span style="color:#bbb;">لا يوجد شعار</span>
                    <?php endif; ?>
                </div>
            </div>
            <div class="form-group">
                <label>رفع شعار جديد (اختياري)</label>
                <input type="file" name="logo" accept="image/*">
            </div>
            <button type="submit" class="btn-main"><i class="fa fa-save"></i> حفظ التغييرات</button>
        </form>
        <a href="partners.php" class="back-btn"><i class="fa fa-arrow-right"></i> العودة للقائمة</a>
    </div>
</body>
</html>
