<?php
session_start();
require_once "../config/db.php";
if (isset($_SESSION['admin_id'])) {
    header("Location: index.php");
    exit;
}
$error = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user = $_POST['username'];
    $pass = $_POST['password'];

// جلب المستخدم فقط بناء على اسم المستخدم ونوعه admin
$stmt = $pdo->prepare("SELECT * FROM users WHERE email=? AND type='admin'");
$stmt->execute([$user]);
$admin = $stmt->fetch();

if ($admin && password_verify($pass, $admin['password'])) {
    $_SESSION['admin_id'] = $admin['id'];
    $_SESSION['admin_name'] = $admin['name'];
    header("Location: index.php");
    exit;
} else {
    $error = "بيانات الدخول غير صحيحة";
}
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8"><title>دخول الإدارة</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@700&display=swap" rel="stylesheet">
    <style>
        body {background:#f8f9fa;font-family:'Cairo',sans-serif;}
        .login-container {
            max-width:400px;
            margin:60px auto;
            background:#fff;
            border-radius:15px;
            box-shadow:0 6px 30px #e6e6e6;
            padding:40px 30px 30px 30px;
        }
        h2 {text-align:center;color:#3e165a;}
        .form-group {margin-bottom:20px;}
        input[type="text"], input[type="password"] {
            width:100%;padding:13px;border-radius:7px;border:1px solid #d5d1e2;margin-bottom:7px;font-size:17px;
        }
        button[type="submit"] {
            width:100%;
            background: linear-gradient(135deg,#3e165a,#7c3aed);
            color:#fff;padding:12px;border:none;border-radius:9px;font-weight:bold;font-size:18px;cursor:pointer;
        }
        .error-msg {
            color:#b50101;
            background:#faecec;
            border-radius:7px;
            padding:9px 13px;
            text-align:center;
            margin-bottom:18px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <h2>دخول لوحة الإدارة</h2>
        <?php if($error): ?><div class="error-msg"><?= $error ?></div><?php endif; ?>
        <form method="post">
            <div class="form-group">
                <input name="username" type="text" placeholder="اسم المستخدم" required>
            </div>
            <div class="form-group">
                <input name="password" type="password" placeholder="كلمة المرور" required>
            </div>
            <button type="submit">دخول</button>
        </form>
    </div>
</body>
</html>
