<?php
require_once "../includes/auth.php";
require_once "../config/db.php";
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>لوحة تحكم الإدارة</title>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    <style>
        body {
            background: #f8f9fa;
            font-family: 'Cairo', sans-serif;
            color: #333;
            margin: 0;
        }
        .dashboard-container {
            max-width: 1100px;
            margin: 60px auto 0;
            padding: 0 15px;
        }
        .dashboard-title {
            text-align: center;
            color: #3e165a;
            font-size: 2.2rem;
            font-weight: 800;
            margin-bottom: 30px;
            letter-spacing: 1px;
        }
        .dashboard-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(210px, 1fr));
            gap: 30px;
        }
        .dashboard-card {
            background: #fff;
            border-radius: 14px;
            box-shadow: 0 5px 24px #e6e6e6;
            padding: 34px 20px 22px 20px;
            text-align: center;
            transition: box-shadow 0.2s, transform 0.15s;
            position: relative;
            overflow: hidden;
        }
        .dashboard-card:hover {
            box-shadow: 0 10px 32px #c3aaf2a9;
            transform: translateY(-5px) scale(1.04);
        }
        .dashboard-card i {
            font-size: 2.7rem;
            color: #7c3aed;
            background: linear-gradient(135deg, #3e165a 60%, #5a2a7a 100%);
            border-radius: 50%;
            padding: 18px;
            margin-bottom: 15px;
            transition: background 0.2s;
        }
        .dashboard-card:hover i {
            background: linear-gradient(135deg, #5a2a7a, #7c3aed);
        }
        .dashboard-card h3 {
            margin: 0 0 7px 0;
            font-size: 1.3rem;
            color: #3e165a;
            font-weight: 700;
        }
        .dashboard-card p {
            color: #888;
            font-size: 1rem;
            margin-bottom: 20px;
        }
        .dashboard-card a {
            background: #7c3aed;
            color: #fff !important;
            padding: 8px 18px;
            border-radius: 7px;
            font-weight: 600;
            font-size: 15px;
            text-decoration: none !important;
            transition: background 0.18s;
            display: inline-block;
        }
        .dashboard-card a:hover {
            background: #3e165a;
        }
        @media (max-width: 600px) {
            .dashboard-title { font-size: 1.3rem; }
            .dashboard-cards { gap: 17px; }
            .dashboard-card { padding: 20px 10px 14px 10px; }
        }
    </style>
</head>
<body>
    <div class="dashboard-container">
        <div class="dashboard-title">
            لوحة تحكم الإدارة
        </div>
        <div class="dashboard-cards">
            <div class="dashboard-card">
                <i class="fas fa-building"></i>
                <h3>الشركات</h3>
                <p>إدارة بيانات الشركات</p>
                <a href="companies.php">دخول</a>
            </div>
            <div class="dashboard-card">
                <i class="fas fa-bullhorn"></i>
                <h3>العروض</h3>
                <p>إدارة العروض والباقات</p>
                <a href="offers.php">دخول</a>
            </div>
            <div class="dashboard-card">
                <i class="fas fa-images"></i>
                <h3>الإعلانات (السلايدر)</h3>
                <p>التحكم في إعلانات الموقع</p>
                <a href="sliders.php">دخول</a>
            </div>
            <div class="dashboard-card">
                <i class="fas fa-handshake"></i>
                <h3>شعارات الشركاء</h3>
                <p>إضافة/تعديل شعارات الشركاء</p>
                <a href="partners.php">دخول</a>
            </div>
            <div class="dashboard-card">
                <i class="fas fa-list"></i>
                <h3>التصنيفات</h3>
                <p>إدارة تصنيفات الشركات</p>
                <a href="categories.php">دخول</a>
            </div>
            <div class="dashboard-card">
                <i class="fas fa-city"></i>
                <h3>المدن</h3>
                <p>التحكم في المدن</p>
                <a href="cities.php">دخول</a>
            </div>
            <div class="dashboard-card">
                <i class="fas fa-envelope"></i>
                <h3>الرسائل</h3>
                <p>استعراض رسائل الزوار</p>
                <a href="messages.php">دخول</a>
            </div>
            <div class="dashboard-card">
                <i class="fas fa-users"></i>
                <h3>المستخدمون</h3>
                <p>إدارة صلاحيات المستخدمين</p>
                <a href="users.php">دخول</a>
            </div>
            <div class="dashboard-card">
                <i class="fas fa-globe"></i>
                <h3>SEO الموقع</h3>
                <p>تحكم العناوين والوصف لكل صفحة</p>
                <a href="seo/index.php">دخول</a>
            </div>
            <div class="dashboard-card">
                <i class="fas fa-sign-out-alt"></i>
                <h3>تسجيل الخروج</h3>
                <p>خروج من اللوحة</p>
                <a href="logout.php">خروج</a>
            </div>
        </div>
    </div>
</body>
</html>
