<?php
require_once __DIR__.'/config/app.php';
require_once __DIR__.'/config/db.php';
require_login(); require_role(['admin']);

$id=(int)($_GET['id']??0);
$u=$pdo->prepare("SELECT * FROM users WHERE id=?"); $u->execute([$id]); $u=$u->fetch();
if(!$u){ http_response_code(404); die('المستخدم غير موجود'); }
$departments = $pdo->query("SELECT id,name FROM departments ORDER BY name")->fetchAll();

$page_title='تعديل مستخدم';
include __DIR__.'/includes/header.php';
?>
<div class="header">
  <div class="page-title"><i class="fa-solid fa-user-pen"></i> <?= e($page_title) ?></div>
</div>

<div class="card" style="max-width:720px">
  <form method="post" action="<?= e(base_url('actions/employee_update.php')) ?>">
    <?= csrf_field() ?>
    <input type="hidden" name="id" value="<?= e($u['id']) ?>">
    <div class="form-grid">
      <div><label>الاسم</label><input class="input" name="name" value="<?= e($u['name']) ?>" required></div>
      <div><label>البريد</label><input class="input" type="email" name="email" value="<?= e($u['email']) ?>" required></div>
      <div><label>كلمة المرور (اتركها فارغة دون تغيير)</label><input class="input" type="password" name="password"></div>
      <div>
        <label>الدور</label>
        <select class="input" name="role" required>
          <?php foreach(['employee'=>'موظف','manager'=>'رئيس قسم','admin'=>'مدير النظام'] as $k=>$v): ?>
            <option value="<?= e($k) ?>" <?= $u['role']===$k?'selected':'' ?>><?= e($v) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label>القسم</label>
        <select class="input" name="department_id">
          <option value="">— بدون —</option>
          <?php foreach($departments as $d): ?>
            <option value="<?= e($d['id']) ?>" <?= (int)$u['department_id']===(int)$d['id']?'selected':'' ?>><?= e($d['name']) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
    </div>
    <div style="margin-top:12px;display:flex;gap:10px;justify-content:flex-end">
      <button class="btn btn-primary"><i class="fa-solid fa-save"></i> حفظ التعديلات</button>
    </div>
  </form>
</div>
<?php include __DIR__.'/includes/footer.php'; ?>
