<?php
require_once __DIR__.'/config/app.php';
require_once __DIR__.'/config/db.php';
require_login();

$page_title = 'المهام';
$uid = current_user_id();
$role = current_role();

$where = '1=1'; $params=[];
if ($role==='manager'){
  $where='(t.manager_id = ? OR t.department_id IN (SELECT department_id FROM department_employees WHERE user_id=?))';
  $params=[$uid,$uid];
}elseif($role==='employee'){
  $where='t.id IN (SELECT task_id FROM task_assignees WHERE user_id=?)';
  $params=[$uid];
}

$stmt=$pdo->prepare("SELECT t.*, d.name AS dept_name FROM tasks t LEFT JOIN departments d ON d.id=t.department_id WHERE $where ORDER BY t.id DESC");
$stmt->execute($params); $rows=$stmt->fetchAll();

include __DIR__.'/includes/header.php';
?>
<div class="header">
  <div class="page-title"><i class="fas fa-tasks"></i> <?= e($page_title) ?></div>
  <div class="header-actions">
    <?php if (can_create_task()): ?>
      <a class="btn btn-primary" href="<?= e(base_url('task_create.php')) ?>"><i class="fas fa-plus"></i> مهمة جديدة</a>
    <?php endif; ?>
  </div>
</div>

<div class="card">
  <table class="table">
    <thead><tr><th>#</th><th>العنوان</th><th>القسم</th><th>الأولوية</th><th>الحالة</th><th>الاستحقاق</th><th></th></tr></thead>
    <tbody>
      <?php foreach($rows as $r): ?>
        <tr>
          <td><?= e($r['id']) ?></td>
          <td><?= e($r['title']) ?></td>
          <td><?= e($r['dept_name'] ?: '—') ?></td>
          <td><span class="task-priority <?= priority_css($r['priority']) ?>"><?= e(ar_priority($r['priority'])) ?></span></td>
          <td><span class="task-status <?= status_css($r['status']) ?>"><?= e(ar_status($r['status'])) ?></span></td>
          <td><?= e($r['due_date']) ?></td>
          <td><a class="btn btn-outline" href="<?= e(base_url('task_view.php?id='.$r['id'])) ?>">فتح</a></td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<?php include __DIR__.'/includes/footer.php'; ?>
