<?php
require_once __DIR__.'/config/app.php';
require_once __DIR__.'/config/db.php';
require_login();

$id = (int)($_GET['id'] ?? 0);

// معلومات المهمة
$stmt = $pdo->prepare("SELECT t.*, d.name AS dept_name, um.name AS manager_name, uc.name AS creator_name
                       FROM tasks t
                       LEFT JOIN departments d ON d.id=t.department_id
                       LEFT JOIN users um ON um.id=t.manager_id
                       LEFT JOIN users uc ON uc.id=t.created_by
                       WHERE t.id=?");
$stmt->execute([$id]);
$task = $stmt->fetch();
if (!$task){ http_response_code(404); die('المهمة غير موجودة'); }

// المعنيّون
$assigneesStmt = $pdo->prepare("SELECT u.id,u.name FROM task_assignees a JOIN users u ON u.id=a.user_id WHERE a.task_id=?");
$assigneesStmt->execute([$id]);
$assignees = $assigneesStmt->fetchAll();

// مرفقات المهمة
$attachmentsStmt = $pdo->prepare("SELECT * FROM task_attachments WHERE task_id=? ORDER BY id");
$attachmentsStmt->execute([$id]);
$attachments = $attachmentsStmt->fetchAll();

// التعليقات
$commentsStmt = $pdo->prepare("SELECT c.*, u.name FROM task_comments c JOIN users u ON u.id=c.user_id WHERE c.task_id=? ORDER BY c.id");
$commentsStmt->execute([$id]);
$comments = $commentsStmt->fetchAll();

// مرفقات التعليقات (مجمّعة لكل تعليق)
$comment_ids = array_column($comments, 'id');
$comment_atts = [];
if ($comment_ids){
  $in = implode(',', array_fill(0, count($comment_ids), '?'));
  $attq = $pdo->prepare("SELECT * FROM task_comment_attachments WHERE comment_id IN ($in) ORDER BY id");
  $attq->execute($comment_ids);
  while($row = $attq->fetch()){
    $comment_atts[$row['comment_id']][] = $row;
  }
}

// قوائم مساعدة للمدير
$employees = $pdo->query("SELECT id,name FROM users WHERE role='employee' ORDER BY name")->fetchAll();
$managers  = $pdo->query("SELECT id,name FROM users WHERE role='manager' ORDER BY name")->fetchAll();

$role = current_role();
$uid  = current_user_id();

// هل المهمة مُسنّدة للموظف الحالي؟
$is_my_task = false;
if ($role === 'employee') {
  $chk = $pdo->prepare("SELECT 1 FROM task_assignees WHERE task_id=? AND user_id=? LIMIT 1");
  $chk->execute([$task['id'], $uid]);
  $is_my_task = (bool)$chk->fetchColumn();
}

$page_title = 'تفاصيل المهمة';
include __DIR__.'/includes/header.php';
?>
<div class="header">
  <div class="page-title"><i class="fas fa-clipboard-list"></i> <?= e($page_title) ?> #<?= e($task['id']) ?></div>
  <div class="header-actions">
    <?php if ($role==='employee' && $is_my_task): ?>
      <!-- أزرار الحالة للموظف -->
      <form method="post" action="<?= e(base_url('actions/status_update.php')) ?>" style="display:inline-flex;gap:8px;flex-wrap:wrap;align-items:center">
        <?= csrf_field() ?>
        <input type="hidden" name="task_id" value="<?= e($task['id']) ?>">
        <?php foreach (['pending','in_progress','completed','cancelled'] as $s): ?>
          <button class="btn <?= $s==='cancelled'?'btn-danger':'btn-outline' ?>" name="status" value="<?= e($s) ?>">
            <?= e(ar_status($s)) ?>
          </button>
        <?php endforeach; ?>
      </form>
    <?php endif; ?>

    <?php if (in_array($role,['admin','manager'])): ?>
      <!-- أزرار الحالة للمدير/مدير النظام -->
      <form method="post" action="<?= e(base_url('actions/status_update.php')) ?>" style="display:inline-flex;gap:8px;flex-wrap:wrap;align-items:center">
        <?= csrf_field() ?>
        <input type="hidden" name="task_id" value="<?= e($task['id']) ?>">
        <?php foreach (['pending','in_progress','completed','cancelled'] as $s): ?>
          <button class="btn <?= $s==='cancelled'?'btn-danger':'btn-outline' ?>" name="status" value="<?= e($s) ?>">
            <?= e(ar_status($s)) ?>
          </button>
        <?php endforeach; ?>
      </form>
    <?php endif; ?>
  </div>
</div>

<div class="grid" style="grid-template-columns: 1.1fr .9fr">
  <!-- العمود الأيسر: تفاصيل المهمة -->
  <div class="card">
    <h3 style="margin-top:0"><?= e($task['title']) ?></h3>

    <!-- وصف المهمة (HTML من المحرّر) -->
    <div><?= $task['description'] ?></div>

    <p style="margin-top:10px">
      <strong>القسم:</strong> <?= e($task['dept_name'] ?: '—') ?> |
      <strong>مدير المهمة:</strong> <?= e($task['manager_name'] ?: '—') ?>
    </p>

    <p>
      <strong>الحالة:</strong>
      <span class="task-status <?= status_css($task['status']) ?> <?= $task['status']==='cancelled'?'status-cancelled':'' ?>">
        <?= e(ar_status($task['status'])) ?>
      </span>
      |
      <strong>الأولوية:</strong>
      <span class="task-priority <?= priority_css($task['priority']) ?>">
        <?= e(ar_priority($task['priority'])) ?>
      </span>
    </p>

    <p>
      <strong>الإنشاء:</strong> <?= e($task['created_at']) ?> بواسطة <?= e($task['creator_name']) ?> |
      <strong>الاستحقاق:</strong> <?= e($task['due_date']) ?>
    </p>

    <h4>المرفقات</h4>
    <ul>
      <?php foreach($attachments as $a): ?>
        <li>
          <?php if ($a['type']==='external'): ?>
            <a href="<?= e($a['file_path']) ?>" target="_blank"><?= e($a['file_name']) ?></a>
            <span class="badge"><?= $a['source'] ? e($a['source']) : 'رابط' ?></span>
          <?php else: ?>
            <a href="<?= e(base_url('uploads/'.$a['file_path'])) ?>" target="_blank"><?= e($a['file_name']) ?></a>
            <span class="badge">رفع</span>
          <?php endif; ?>
        </li>
      <?php endforeach; ?>
    </ul>
  </div>

  <!-- العمود الأيمن: المعنيون والتحويل -->
  <div class="card">
    <h4>المعنيّون</h4>
    <ul>
      <?php foreach($assignees as $u): ?>
        <li><?= e($u['name']) ?></li>
      <?php endforeach; ?>
    </ul>

    <?php if (in_array($role,['admin','manager'])): ?>
      <hr>
      <h4>تحويل/تعديل المعنيين</h4>
      <form method="post" action="<?= e(base_url('actions/reassign_users.php')) ?>">
        <?= csrf_field() ?>
        <input type="hidden" name="task_id" value="<?= e($task['id']) ?>">
        <select class="input" name="assignees[]" multiple size="8">
          <?php
            $assignee_ids = array_column($assignees, 'id');
            foreach($employees as $e):
          ?>
            <option value="<?= e($e['id']) ?>" <?= in_array($e['id'], $assignee_ids) ? 'selected' : '' ?>>
              <?= e($e['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
        <div style="margin-top:8px;text-align:left">
          <button class="btn btn-primary"><i class="fa-solid fa-user-gear"></i> حفظ التحويل</button>
        </div>
      </form>

      <hr>
      <h4>تعيين/تغيير مدير المهمة</h4>
      <form method="post" action="<?= e(base_url('actions/assign_manager.php')) ?>" style="display:flex;gap:8px;align-items:center">
        <?= csrf_field() ?>
        <input type="hidden" name="task_id" value="<?= e($task['id']) ?>">
        <select class="input" name="manager_id">
          <option value="">—</option>
          <?php foreach($managers as $m): ?>
            <option value="<?= e($m['id']) ?>" <?= (int)$task['manager_id']===(int)$m['id']?'selected':'' ?>>
              <?= e($m['name']) ?>
            </option>
          <?php endforeach; ?>
        </select>
        <button class="btn btn-outline"><i class="fas fa-user-tie"></i> حفظ</button>
      </form>
    <?php endif; ?>

    <!-- ===== التعليقات + مرفقات التعليقات ===== -->
    <hr>
    <h4>التعليقات</h4>

    <ul>
      <?php foreach($comments as $c): ?>
        <li style="margin-bottom:12px">
          <strong><?= e($c['name']) ?>:</strong>
          <div><?= $c['comment_text'] /* HTML من Quill */ ?></div>
          <small style="color:#777">[<?= e($c['created_at']) ?>]</small>

          <?php if (!empty($comment_atts[$c['id']])): ?>
            <div style="margin-top:6px">
              <strong>مرفقات:</strong>
              <ul>
                <?php foreach($comment_atts[$c['id']] as $a): ?>
                  <li>
                    <?php if ($a['type']==='external'): ?>
                      <a href="<?= e($a['file_path']) ?>" target="_blank"><?= e($a['file_name']) ?></a>
                      <span class="badge"><?= $a['source'] ? e($a['source']) : 'رابط' ?></span>
                    <?php else: ?>
                      <a href="<?= e(base_url('uploads/'.$a['file_path'])) ?>" target="_blank"><?= e($a['file_name']) ?></a>
                      <span class="badge">رفع</span>
                    <?php endif; ?>
                  </li>
                <?php endforeach; ?>
              </ul>
            </div>
          <?php endif; ?>
        </li>
      <?php endforeach; ?>
    </ul>

    <!-- محرر Quill للتعليقات + مرفقات -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/quill@1.3.7/dist/quill.snow.css">
    <script src="https://cdn.jsdelivr.net/npm/quill@1.3.7/dist/quill.min.js"></script>

    <form id="comment-form" method="post" action="<?= e(base_url('actions/comment_save.php')) ?>" enctype="multipart/form-data">
      <?= csrf_field() ?>
      <input type="hidden" name="task_id" value="<?= e($task['id']) ?>">

      <div id="c-quill" style="background:#fff;border:1px solid #e6ecf1;border-radius:12px;margin-bottom:8px"></div>
      <input type="hidden" name="comment_text" id="c-desc">

      <div class="file-field" style="margin-top:8px">
        <input id="comment_files" type="file" name="comment_files[]" multiple>
        <label for="comment_files" class="btn btn-outline file-btn">
          <i class="fa-solid fa-paperclip"></i> إرفاق ملفات
        </label>
        <div id="comment-files-info" class="badge" style="display:block;margin-top:6px">لم يتم اختيار أي ملف</div>
      </div>

      <div style="margin-top:10px">
        <label>رابط تحميل خارجي (اختياري)</label>
        <input class="input" type="url" name="comment_external_url" placeholder="https://example.com/file.pdf">
      </div>

      <div style="margin-top:10px;text-align:left">
        <button class="btn btn-primary"><i class="fas fa-paper-plane"></i> إرسال</button>
      </div>
    </form>

    <script>
    document.addEventListener('DOMContentLoaded', function(){
      if (window.Quill){
        const cq = new Quill('#c-quill', {
          theme: 'snow',
          placeholder: 'اكتب تعليقك…',
          modules: {
            toolbar: [
              [{ header: [false, 3] }],
              ['bold','italic','underline','strike'],
              [{ list:'ordered' }, { list:'bullet' }],
              [{ align:[] }, { direction:'rtl' }],
              ['link','blockquote','code-block','clean']
            ]
          }
        });
        // RTL
        const ed = document.querySelector('#c-quill .ql-editor');
        ed.setAttribute('dir','rtl'); ed.style.textAlign='right';
        document.getElementById('comment-form').addEventListener('submit', function(){
          document.getElementById('c-desc').value = cq.root.innerHTML;
        });
      }

      // عرض أسماء ملفات التعليق المختارة
      const cfi = document.getElementById('comment_files'), cinfo = document.getElementById('comment-files-info');
      if (cfi && cinfo){
        cfi.addEventListener('change', () => {
          cinfo.textContent = cfi.files.length
            ? Array.from(cfi.files).map(f => f.name).join(' • ')
            : 'لم يتم اختيار أي ملف';
        });
      }
    });
    </script>
  </div>
</div>

<?php include __DIR__.'/includes/footer.php'; ?>
