<?php
require_once __DIR__.'/config/app.php';
require_once __DIR__.'/config/db.php';
require_login(); require_role(['admin','manager']);

$page_title = 'إنشاء مهمة';
$departments = $pdo->query("SELECT id,name FROM departments ORDER BY name")->fetchAll();
$managers    = $pdo->query("SELECT id,name FROM users WHERE role='manager' ORDER BY name")->fetchAll();
$employees   = $pdo->query("SELECT id,name FROM users WHERE role='employee' ORDER BY name")->fetchAll();

include __DIR__.'/includes/header.php';
?>
<!-- Quill (مجاني) -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/quill@1.3.7/dist/quill.snow.css">
<script src="https://cdn.jsdelivr.net/npm/quill@1.3.7/dist/quill.min.js"></script>

<div class="header">
  <div class="page-title"><i class="fas fa-plus"></i> <?= e($page_title) ?></div>
</div>

<div class="card">
  <form id="task-form" method="post" action="<?= e(base_url('actions/task_save.php')) ?>" enctype="multipart/form-data">
    <?= csrf_field() ?>
    <div class="form-grid">
      <div><label>عنوان المهمة</label><input class="input" name="title" required></div>

      <div><label>القسم</label>
        <select class="input" name="department_id">
          <option value="">—</option>
          <?php foreach($departments as $d): ?><option value="<?= e($d['id']) ?>"><?= e($d['name']) ?></option><?php endforeach; ?>
        </select>
      </div>

      <div><label>مدير المهمة</label>
        <select class="input" name="manager_id">
          <option value="">—</option>
          <?php foreach($managers as $m): ?><option value="<?= e($m['id']) ?>"><?= e($m['name']) ?></option><?php endforeach; ?>
        </select>
      </div>

      <div>
        <label>الأولوية</label>
        <div class="toggle-group" data-toggle-group="priority">
          <label class="toggle active"><input type="radio" name="priority" value="medium" checked> متوسطة</label>
          <label class="toggle"><input type="radio" name="priority" value="high"> عالية</label>
          <label class="toggle"><input type="radio" name="priority" value="low"> منخفضة</label>
        </div>
      </div>

      <div><label>تاريخ الاستحقاق</label><input class="input" type="date" name="due_date"></div>

      <div style="grid-column:1/-1">
        <label>الوصف</label>
        <!-- محرّر مرئي -->
        <div id="quill-editor"></div>
        <!-- حقل مخفي تُرسل فيه HTML الوصف -->
        <input type="hidden" name="description" id="desc-input">
      </div>

     <div style="grid-column:1/-1">
  <label>مرفقات من الجهاز (ملفات متعددة)</label>

  <div class="file-field">
    <input id="files" class="input" type="file" name="files[]" multiple>
    <label for="files" class="btn btn-outline" style="margin-top:8px">
      <i class="fa-solid fa-paperclip"></i> استعراض ملفات
    </label>
    <div id="files-info" class="badge" style="display:block;margin-top:6px">لم يتم اختيار أي ملف</div>
  </div>
</div>

<script>
  const fi = document.getElementById('files'), info = document.getElementById('files-info');
  if (fi && info) {
    fi.addEventListener('change', () => {
      info.textContent = fi.files.length
        ? Array.from(fi.files).map(f => f.name).join(' • ')
        : 'لم يتم اختيار أي ملف';
    });
  }
</script>


      <div style="grid-column:1/-1">
        <label>رابط تحميل خارجي (اختياري)</label>
        <input class="input" type="url" name="external_url" placeholder="https://example.com/file.pdf">
        <small>ضع رابطًا مباشرًا (إن وُجد) لملف على أي خدمة خارجية.</small>
      </div>
    </div>

    <div style="margin-top:12px;display:flex;gap:10px;justify-content:flex-end">
      <button class="btn btn-primary"><i class="fas fa-save"></i> حفظ</button>
    </div>
  </form>
</div>
<?php include __DIR__.'/includes/footer.php'; ?>
