<?php
require_once __DIR__.'/config/app.php';
require_once __DIR__.'/config/db.php';
require_login(); require_role(['admin','manager']);
$page_title = 'التقارير';
$by_status = $pdo->query("SELECT status, COUNT(*) c FROM tasks GROUP BY status")->fetchAll();
$by_dept   = $pdo->query("SELECT d.name dept, COUNT(*) c FROM tasks t LEFT JOIN departments d ON d.id=t.department_id GROUP BY d.name")->fetchAll();
include __DIR__.'/includes/header.php';
?>
<div class="header"><div class="page-title"><i class="fas fa-chart-bar"></i> <?= e($page_title) ?></div></div>
<div class="grid" style="grid-template-columns:1fr 1fr">
  <div class="card">
    <h3>حسب الحالة</h3>
    <ul><?php foreach($by_status as $r): ?><li><?= e($r['status']) ?>: <strong><?= e($r['c']) ?></strong></li><?php endforeach; ?></ul>
  </div>
  <div class="card">
    <h3>حسب القسم</h3>
    <ul><?php foreach($by_dept as $r): ?><li><?= e($r['dept'] ?: '—') ?>: <strong><?= e($r['c']) ?></strong></li><?php endforeach; ?></ul>
  </div>
</div>
<?php include __DIR__.'/includes/footer.php'; ?>
