<?php
require_once __DIR__.'/config/app.php';
if (is_logged_in()){ header("Location: ".base_url('dashboard.php')); exit; }
$page_title = 'تسجيل الدخول';

// قراءة كود الخطأ من الرابط
$err = $_GET['err'] ?? '';
$msg = '';
if ($err === '1')           $msg = 'بيانات الدخول غير صحيحة.';
elseif ($err === 'csrf')    $msg = 'انتهت الجلسة الأمنية (CSRF). حدِّث الصفحة وأعد المحاولة.';
elseif ($err === 'no_post') $msg = 'الوصول غير صحيح للنموذج.';

include __DIR__.'/includes/header.php';
?>
<div class="header">
  <div class="page-title"><i class="fas fa-sign-in-alt"></i> <?= e($page_title) ?></div>
</div>

<div class="card" style="max-width:520px;margin:auto">
  <?php if ($msg): ?>
    <div style="background:#fdecea;border:1px solid #f5c2c7;color:#b02a37;padding:10px 12px;border-radius:8px;margin-bottom:12px">
      <i class="fa-solid fa-circle-exclamation"></i> <?= e($msg) ?>
    </div>
  <?php endif; ?>

  <form method="post" action="<?= e(base_url('actions/auth_login.php')) ?>" novalidate>
    <?= csrf_field() ?>
    <div class="form-grid">
      <div>
        <label>البريد الإلكتروني</label>
        <input class="input" type="email" name="email" required autocomplete="username">
      </div>
      <div>
        <label>كلمة المرور</label>
        <input class="input" type="password" name="password" required autocomplete="current-password">
      </div>
    </div>
    <div style="margin-top:12px;display:flex;gap:10px;justify-content:flex-end">
      <button class="btn btn-primary"><i class="fas fa-door-open"></i> دخول</button>
    </div>
  </form>

  <p style="margin-top:8px;color:#777">
    مستخدم افتراضي للتجربة: <b>admin@asnad.local</b> / <b>admin123</b>
  </p>
</div>
<?php include __DIR__.'/includes/footer.php'; ?>
