<?php
// includes/header.php
require_once __DIR__ . '/../config/app.php';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= e($page_title ?? 'نظام إسناد المهام') ?></title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="stylesheet" href="<?= e(base_url('assets/css/style.css')) ?>">
  <style>
    /* خط كايرو */
    @import url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap');
    body,button,input,select,textarea{font-family:'Cairo',system-ui,-apple-system,Segoe UI,Roboto,Ubuntu,'Helvetica Neue',Arial,"Noto Sans",sans-serif}
  </style>
</head>
<body>
<div class="container">
  <div class="sidebar">
    <div class="logo"><h2><i class="fas fa-tasks"></i> <span>نظام المهام</span></h2></div>
    <?php if (is_logged_in()): ?>
    <div class="user-profile">
      <div class="user-avatar"><i class="fas fa-user"></i></div>
      <div class="user-name"><?= e(current_user_name()) ?></div>
      <div class="user-role"><?= e(current_role()) ?></div>
    </div>
    <?php endif; ?>
    <ul class="nav-links">
      <?php $curr = basename($_SERVER['SCRIPT_NAME']); ?>
      <li class="<?= $curr==='dashboard.php'?'active':'' ?>"><a href="<?= e(base_url('dashboard.php')) ?>"><i class="fas fa-home"></i><span>الرئيسية</span></a></li>
      <li class="<?= ($curr==='tasks.php' || $curr==='task_create.php')?'active':'' ?>"><a href="<?= e(base_url('tasks.php')) ?>"><i class="fas fa-tasks"></i><span>المهام</span></a></li>
      <li class="<?= $curr==='departments.php'?'active':'' ?>"><a href="<?= e(base_url('departments.php')) ?>"><i class="fas fa-building"></i><span>الأقسام</span></a></li>
      <li class="<?= $curr==='employees.php'?'active':'' ?>"><a href="<?= e(base_url('employees.php')) ?>"><i class="fas fa-users"></i><span>المستخدمون</span></a></li>
      <li class="<?= $curr==='reports.php'?'active':'' ?>"><a href="<?= e(base_url('reports.php')) ?>"><i class="fas fa-chart-bar"></i><span>التقارير</span></a></li>
      <li><a href="<?= e(base_url('logout.php')) ?>"><i class="fas fa-sign-out-alt"></i><span>تسجيل الخروج</span></a></li>
    </ul>
  </div>
  <div class="main-content">
