<?php
require_once __DIR__.'/config/app.php';
require_once __DIR__.'/config/db.php';
require_login(); require_role(['admin']);

$page_title = 'إدارة المستخدمين';
$users = $pdo->query("SELECT u.*, d.name AS dept_name FROM users u LEFT JOIN departments d ON d.id=u.department_id ORDER BY u.id DESC")->fetchAll();
$departments = $pdo->query("SELECT id,name FROM departments ORDER BY name")->fetchAll();

include __DIR__.'/includes/header.php';
?>
<div class="header">
  <div class="page-title"><i class="fas fa-users"></i> <?= e($page_title) ?></div>
  <div class="header-actions">
    <button form="user-form" class="btn btn-primary"><i class="fas fa-save"></i> حفظ مستخدم جديد</button>
  </div>
</div>

<div class="grid" style="grid-template-columns:1.2fr .8fr">
  <div class="card">
    <table class="table">
      <thead><tr><th>#</th><th>الاسم</th><th>البريد</th><th>الدور</th><th>القسم</th><th></th></tr></thead>
      <tbody>
      <?php foreach($users as $u): ?>
        <tr>
          <td><?= e($u['id']) ?></td>
          <td><?= e($u['name']) ?></td>
          <td><?= e($u['email']) ?></td>
          <td><span class="badge"><?= e($u['role']) ?></span></td>
          <td><?= e($u['dept_name'] ?: '—') ?></td>
          <td><a class="btn btn-outline" href="<?= e(base_url('user_edit.php?id='.$u['id'])) ?>"><i class="fa-solid fa-pen"></i> تعديل</a></td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>

  <div class="card">
    <form id="user-form" method="post" action="<?= e(base_url('actions/employee_save.php')) ?>">
      <?= csrf_field() ?>
      <div class="form-grid">
        <div><label>الاسم</label><input class="input" name="name" required></div>
        <div><label>البريد</label><input class="input" type="email" name="email" required></div>
        <div><label>كلمة المرور</label><input class="input" type="password" name="password" required></div>
        <div>
          <label>الدور</label>
          <select class="input" name="role" required>
            <option value="employee">موظف</option>
            <option value="manager">رئيس قسم</option>
            <option value="admin">مدير النظام</option>
          </select>
        </div>
        <div>
          <label>القسم</label>
          <select class="input" name="department_id">
            <option value="">— بدون —</option>
            <?php foreach($departments as $d): ?>
              <option value="<?= e($d['id']) ?>"><?= e($d['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
      </div>
    </form>
  </div>
</div>
<?php include __DIR__.'/includes/footer.php'; ?>
