<?php
require_once __DIR__.'/config/app.php';
require_once __DIR__.'/config/db.php';
require_login();
require_role(['admin','manager']);

$page_title = 'إدارة الأقسام';

// جلب الأقسام والمدراء
$departments = $pdo->query("SELECT d.*, u.name AS manager_name FROM departments d LEFT JOIN users u ON u.id=d.manager_id ORDER BY d.id DESC")->fetchAll();
$managers = $pdo->query("SELECT id,name FROM users WHERE role='manager' ORDER BY name")->fetchAll();

include __DIR__.'/includes/header.php';
?>
<div class="header">
  <div class="page-title"><i class="fas fa-building"></i> <?= e($page_title) ?></div>
  <div class="header-actions">
    <button form="dept-form" class="btn btn-primary"><i class="fas fa-save"></i> حفظ القسم</button>
  </div>
</div>

<div class="grid" style="grid-template-columns:1.2fr .8fr">
  <div class="card">
    <table class="table">
      <thead><tr><th>#</th><th>الاسم</th><th>المدير</th></tr></thead>
    <tbody>
    <?php foreach($departments as $d): ?>
      <tr>
        <td><?= e($d['id']) ?></td>
        <td><?= e($d['name']) ?></td>
        <td><?= e($d['manager_name'] ?: '—') ?></td>
      </tr>
    <?php endforeach; ?>
    </tbody></table>
  </div>
  <div class="card">
    <form id="dept-form" method="post" action="<?= e(base_url('actions/department_save.php')) ?>">
      <?= csrf_field() ?>
      <div class="form-grid">
        <div><label>اسم القسم</label><input class="input" name="name" required></div>
        <div><label>المدير</label>
          <select class="input" name="manager_id">
            <option value="">— بدون —</option>
            <?php foreach($managers as $m): ?>
              <option value="<?= e($m['id']) ?>"><?= e($m['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div style="grid-column:1/-1">
          <label>الوصف</label>
          <textarea class="input" name="description" rows="3"></textarea>
        </div>
      </div>
    </form>
  </div>
</div>
<?php include __DIR__.'/includes/footer.php'; ?>
