<?php
require_once __DIR__.'/config/app.php';
require_once __DIR__.'/config/db.php';
require_login();

$page_title = 'لوحة تحكم المدير';
// صلاحيات الرؤية: المدير العام يرى الكل، مدير القسم يرى قسمه، الموظف يرى مهامه فقط
$role = current_role();
$uid = current_user_id();

$where = '1=1';
$params = [];
if ($role === 'manager'){
    $where = '(tasks.manager_id = ? OR tasks.department_id IN (SELECT department_id FROM department_employees WHERE user_id=?))';
    $params = [$uid, $uid];
} elseif ($role === 'employee'){
    $where = 'tasks.id IN (SELECT task_id FROM task_assignees WHERE user_id=?)';
    $params = [$uid];
}

function count_by_status($pdo, $where, $params, $status){
    $stmt = $pdo->prepare("SELECT COUNT(*) AS c FROM tasks WHERE $where AND status=?");
    $stmt->execute(array_merge($params, [$status]));
    return (int)$stmt->fetchColumn();
}
$pending   = count_by_status($pdo, $where, $params, 'pending');
$progress  = count_by_status($pdo, $where, $params, 'in_progress');
$completed = count_by_status($pdo, $where, $params, 'completed');
$cancelled = count_by_status($pdo, $where, $params, 'cancelled');

$recent = $pdo->prepare("SELECT tasks.*, d.name AS dept_name FROM tasks LEFT JOIN departments d ON d.id=tasks.department_id WHERE $where ORDER BY tasks.id DESC LIMIT 10");
$recent->execute($params);
$recent_tasks = $recent->fetchAll();

include __DIR__.'/includes/header.php';
?>
<div class="header">
  <div class="search-box">
    <i class="fas fa-search"></i>
    <input type="text" id="q" placeholder="ابحث عن مهمة أو موظف...">
  </div>
  <div class="header-actions">
    <a class="btn btn-primary" href="<?= e(base_url('task_create.php')) ?>"><i class="fas fa-plus"></i> مهمة جديدة</a>
  </div>
</div>

<h1 class="page-title"><i class="fas fa-tachometer-alt"></i> لوحة التحكم</h1>

<div class="stats-cards">
  <div class="stat-card pending"><div class="stat-icon"><i class="fas fa-clock"></i></div><div class="stat-info"><h3><?= $pending ?></h3><p>معلقة</p></div></div>
  <div class="stat-card progress"><div class="stat-icon"><i class="fas fa-spinner"></i></div><div class="stat-info"><h3><?= $progress ?></h3><p>قيد التنفيذ</p></div></div>
  <div class="stat-card completed"><div class="stat-icon"><i class="fas fa-check-circle"></i></div><div class="stat-info"><h3><?= $completed ?></h3><p>مكتملة</p></div></div>
  <div class="stat-card cancelled"><div class="stat-icon"><i class="fas fa-times-circle"></i></div><div class="stat-info"><h3><?= $cancelled ?></h3><p>ملغاة</p></div></div>
</div>

<div class="tasks-section">
  <div class="section-header">
    <h2 class="section-title">المهام الحديثة</h2>
    <a href="<?= e(base_url('tasks.php')) ?>" class="btn btn-primary">عرض الكل</a>
  </div>
  <ul class="tasks-list">
    <?php foreach($recent_tasks as $t): ?>
      <li class="task-item">
        <div class="task-info">
          <h3><a href="<?= e(base_url('task_view.php?id='.$t['id'])) ?>"><?= e($t['title']) ?></a></h3>
          <p>القسم: <?= e($t['dept_name'] ?: '—') ?> | الاستحقاق: <?= e($t['due_date']) ?></p>
        </div>
        <div class="task-meta">
          <span class="task-priority <?= $t['priority']==='high'?'priority-high':($t['priority']==='medium'?'priority-medium':'priority-low') ?>"><?= e($t['priority']) ?></span>
          <span class="task-status <?= $t['status']==='pending'?'status-pending':($t['status']==='in_progress'?'status-progress':($t['status']==='completed'?'status-completed':'')) ?>"><?= e($t['status']) ?></span>
        </div>
      </li>
    <?php endforeach; ?>
  </ul>
</div>
<?php include __DIR__.'/includes/footer.php'; ?>
