<?php
// config/app.php
if (session_status() === PHP_SESSION_NONE) session_start();
date_default_timezone_set('Asia/Riyadh');

/** إعدادات عامة */
$APP_CONFIG = [
  'google_api_key'   => '',
  'google_client_id' => '',
  'ms_client_id'     => '',
  'base_url'         => 'http://localhost/asnad/', // ← عدّلها لمسارك وانتهِ بـ /
  'max_upload_mb'    => 50,
];

/** توليد روابط مطلقة */
function base_url($path = ''){
  global $APP_CONFIG;
  if (!empty($APP_CONFIG['base_url'])) {
    return rtrim($APP_CONFIG['base_url'], '/').'/'.ltrim($path, '/');
  }
  $scheme  = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host    = $_SERVER['HTTP_HOST'] ?? 'localhost';
  $doc     = rtrim(str_replace('\\','/', $_SERVER['DOCUMENT_ROOT'] ?? ''), '/');
  $rootFs  = rtrim(str_replace('\\','/', realpath(__DIR__.'/..') ?: ''), '/');
  $rootWeb = ( $doc && $rootFs && strpos($rootFs, $doc) === 0 ) ? substr($rootFs, strlen($doc)) : '';
  if (!$rootWeb){
    $scriptDir = rtrim(str_replace(basename($_SERVER['SCRIPT_NAME'] ?? ''), '', $_SERVER['SCRIPT_NAME'] ?? ''), '/');
    $rootWeb   = $scriptDir;
  }
  return $scheme.'://'.$host.rtrim($rootWeb, '/').'/'.ltrim($path, '/');
}

/** أدوات عامة */
function e($v){ return htmlspecialchars((string)$v, ENT_QUOTES, 'UTF-8'); }
function is_logged_in(){ return !empty($_SESSION['user_id']); }
function current_user_id(){ return $_SESSION['user_id'] ?? null; }
function current_role(){ return $_SESSION['user_role'] ?? 'guest'; }
function current_user_name(){ return $_SESSION['user_name'] ?? ''; }

function require_login(){
  if (!is_logged_in()){ header("Location: ".base_url('login.php')); exit; }
}
function require_role($roles){
  $roles=(array)$roles;
  if(!in_array(current_role(), $roles, true)){ http_response_code(403); die('غير مصرح'); }
}

/** حوكمة إنشاء المهام */
function can_create_task(){ return in_array(current_role(), ['admin','manager'], true); }

/** تعريب الحالة والأولوية (عرضاً) */
function ar_status($s){
  $map=['pending'=>'معلقة','in_progress'=>'قيد التنفيذ','completed'=>'مكتملة','cancelled'=>'ملغاة'];
  return $map[$s] ?? $s;
}
function ar_priority($p){
  $map=['low'=>'منخفضة','medium'=>'متوسطة','high'=>'عالية'];
  return $map[$p] ?? $p;
}
function status_css($s){
  return $s==='pending'?'status-pending':($s==='in_progress'?'status-progress':($s==='completed'?'status-completed':''));
}
function priority_css($p){
  return $p==='high'?'priority-high':($p==='medium'?'priority-medium':'priority-low');
}

/** صلاحيات تغيير الحالة */
function allowed_statuses_for($role){
  // الموظف: يُمكنه تغيير الحالة إلى أي من الحالات الأربع للمهمة المسندة له
  if ($role === 'employee') return ['pending','in_progress','completed','cancelled'];

  // المدير/المدير العام: كل الحالات
  if (in_array($role, ['manager','admin'], true))
    return ['pending','in_progress','completed','cancelled'];

  return [];
}


/** CSRF */
function csrf_token(){ if(empty($_SESSION['csrf'])) $_SESSION['csrf']=bin2hex(random_bytes(16)); return $_SESSION['csrf']; }
function csrf_field(){ return '<input type="hidden" name="csrf" value="'.e(csrf_token()).'">'; }
function csrf_check(){
  if($_SERVER['REQUEST_METHOD']==='POST'){
    $ok = isset($_POST['csrf']) && hash_equals($_SESSION['csrf'] ?? '', $_POST['csrf']);
    if(!$ok){ http_response_code(400); die('CSRF token mismatch'); }
  }
}

/** رفع الملفات */
function ensure_upload_dir(){ $dir=__DIR__.'/../uploads'; if(!is_dir($dir)) mkdir($dir,0775,true); return $dir; }
function random_name($len=16){ $c='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'; $r=''; for($i=0;$i<$len;$i++) $r.=$c[random_int(0,strlen($c)-1)]; return $r; }
function bytes_from_mb($mb){ return (int)$mb * 1024 * 1024; }
