// assets/js/app.js
document.addEventListener('DOMContentLoaded', function () {
  // نبضة للأيقونة
  const logoIcon = document.querySelector('.logo i');
  if (logoIcon) setInterval(() => logoIcon.classList.toggle('pulse'), 2200);

  // تفعيل أزرار toggle (أولوية/حالة داخل النماذج)
  document.querySelectorAll('[data-toggle-group]').forEach(group => {
    group.querySelectorAll('.toggle').forEach(t => {
      t.addEventListener('click', () => {
        group.querySelectorAll('.toggle').forEach(x => x.classList.remove('active'));
        t.classList.add('active');
        const radio = t.querySelector('input[type=radio]');
        if (radio) radio.checked = true;
      });
    });
  });

  // -------- محرّر Quill (مجاني) ----------
  const quillHost = document.getElementById('quill-editor');
  const quillHidden = document.getElementById('desc-input');
  if (quillHost && quillHidden && window.Quill) {
    const q = new Quill('#quill-editor', {
      theme: 'snow',
      placeholder: 'اكتب وصف المهمة بالتفصيل…',
      modules: {
        toolbar: [
          [{ header: [false, 2, 3] }],
          ['bold', 'italic', 'underline', 'strike'],
          [{ list: 'ordered' }, { list: 'bullet' }],
          [{ align: [] }, { direction: 'rtl' }],
          ['link', 'blockquote', 'code-block', 'clean']
        ]
      }
    });
    // RTL افتراضي
    quillHost.querySelector('.ql-editor').setAttribute('dir', 'rtl');
    quillHost.querySelector('.ql-editor').style.textAlign = 'right';

    // عند الإرسال: انقل HTML إلى الحقل المخفي
    const form = quillHost.closest('form');
    if (form) {
      form.addEventListener('submit', () => {
        quillHidden.value = q.root.innerHTML;
      });
    }
  }
});
