<?php
require_once __DIR__.'/../config/app.php';
require_once __DIR__.'/../config/db.php';
require_login(); csrf_check();

$title = trim($_POST['title'] ?? '');
$department_id = !empty($_POST['department_id']) ? (int)$_POST['department_id'] : null;
$manager_id = !empty($_POST['manager_id']) ? (int)$_POST['manager_id'] : null;
$priority = $_POST['priority'] ?? 'medium';
$due_date = $_POST['due_date'] ?? null;
$description = trim($_POST['description'] ?? '');
$assignees = $_POST['assignees'] ?? [];

if ($title===''){ header('Location: '.base_url('task_create.php')); exit; }

$pdo->beginTransaction();
try {
  $stmt = $pdo->prepare("INSERT INTO tasks (title,description,department_id,manager_id,priority,status,due_date,created_by,created_at) VALUES (?,?,?,?,?,'pending',?,?,NOW())");
  $stmt->execute([$title,$description,$department_id,$manager_id,$priority,$due_date,current_user_id()]);
  $task_id = (int)$pdo->lastInsertId();

  // إسناد موظفين
  if (!empty($assignees)){
    $ins = $pdo->prepare("INSERT INTO task_assignees (task_id,user_id) VALUES (?,?)");
    foreach($assignees as $uid){
      $ins->execute([$task_id, (int)$uid]);
    }
  }

  // مرفقات الجهاز
  ensure_upload_dir();
  $max = bytes_from_mb(($GLOBALS['APP_CONFIG']['max_upload_mb'] ?? 50));
  if (!empty($_FILES['files']['name'][0])){
    for($i=0; $i<count($_FILES['files']['name']); $i++){
      if ($_FILES['files']['error'][$i] === UPLOAD_ERR_OK){
        $name = $_FILES['files']['name'][$i];
        $tmp  = $_FILES['files']['tmp_name'][$i];
        $size = (int)$_FILES['files']['size'][$i];
        if ($size > $max) continue;
        $ext = pathinfo($name, PATHINFO_EXTENSION);
        $safe = date('Ymd_His').'_'.$task_id.'_'.bin2hex(random_bytes(4)).($ext?'.'.$ext:'');
        $dest = __DIR__.'/../uploads/'.$safe;
        if (move_uploaded_file($tmp, $dest)){
          $mime = mime_content_type($dest) ?: '';
          $pdo->prepare("INSERT INTO task_attachments (task_id,type,source,file_name,file_path,mime_type,size,created_at) VALUES (?,?,?,?,?,?,?,NOW())")
              ->execute([$task_id,'upload','device',$name,$safe,$mime,$size]);
        }
      }
    }
  }

  // رابط خارجي واحد (اختياري)
  $external_url = trim($_POST['external_url'] ?? '');
  if ($external_url !== ''){
    // استنتاج اسم للملف من الرابط (إن أمكن)
    $parsed = parse_url($external_url);
    $fileName = '';
    if (!empty($parsed['path'])) {
      $base = basename($parsed['path']);
      $fileName = $base !== '' ? $base : '';
    }
    if ($fileName === '') {
      $fileName = $parsed['host'] ?? 'external-link';
    }
    // type=external, source='' (مطابق للـ ENUM)
    $pdo->prepare("INSERT INTO task_attachments (task_id,type,source,file_name,file_path,mime_type,size,created_at) VALUES (?,?,?,?,?,'',0,NOW())")
        ->execute([$task_id,'external','',$fileName,$external_url]);
  }

  $pdo->commit();
} catch(Exception $e){
  $pdo->rollBack();
  http_response_code(500);
  die('خطأ أثناء الحفظ');
}

header("Location: ".base_url('task_view.php?id='.$task_id));
exit;
