<?php
require_once __DIR__.'/../config/app.php';
require_once __DIR__.'/../config/db.php';
require_login(); require_role(['admin']); csrf_check();

$name = trim($_POST['name'] ?? '');
$email = trim($_POST['email'] ?? '');
$pwd = $_POST['password'] ?? '';
$role = $_POST['role'] ?? 'employee';
$department_id = !empty($_POST['department_id']) ? (int)$_POST['department_id'] : null;

if ($name==='' || $email==='' || $pwd===''){ header('Location: '.base_url('employees.php')); exit; }

$hash = password_hash($pwd, PASSWORD_BCRYPT);
$stmt = $pdo->prepare("INSERT INTO users (name,email,password_hash,role,department_id,created_at) VALUES (?,?,?,?,?,NOW())");
$stmt->execute([$name,$email,$hash,$role,$department_id]);

if ($department_id){
  // كعضو في القسم
  $pdo->prepare("INSERT IGNORE INTO department_employees (department_id, user_id) VALUES (?,?)")->execute([$department_id, $pdo->lastInsertId()]);
}

header("Location: ".base_url('employees.php'));
exit;
