<?php
require_once __DIR__.'/../config/app.php';
require_once __DIR__.'/../config/db.php';
require_login(); csrf_check();

$task_id = (int)($_POST['task_id'] ?? 0);
$comment_text = trim($_POST['comment_text'] ?? ''); // HTML من Quill
$uid = current_user_id();

if (!$task_id || $comment_text===''){
  header('Location: '.base_url('task_view.php?id='.$task_id)); exit;
}

// احفظ التعليق
$stmt = $pdo->prepare("INSERT INTO task_comments (task_id, user_id, comment_text, created_at) VALUES (?, ?, ?, NOW())");
$stmt->execute([$task_id, $uid, $comment_text]);
$comment_id = (int)$pdo->lastInsertId();

// مرفقات من الجهاز
ensure_upload_dir();
$max = bytes_from_mb(($GLOBALS['APP_CONFIG']['max_upload_mb'] ?? 50));
if (!empty($_FILES['comment_files']['name'][0])) {
  for ($i=0; $i<count($_FILES['comment_files']['name']); $i++) {
    if ($_FILES['comment_files']['error'][$i] === UPLOAD_ERR_OK) {
      $name = $_FILES['comment_files']['name'][$i];
      $tmp  = $_FILES['comment_files']['tmp_name'][$i];
      $size = (int)$_FILES['comment_files']['size'][$i];
      if ($size > $max) continue;
      $ext  = pathinfo($name, PATHINFO_EXTENSION);
      $safe = 'c'.$comment_id.'_'.date('Ymd_His').'_'.bin2hex(random_bytes(4)).($ext?'.'.$ext:'');
      $dest = __DIR__.'/../uploads/'.$safe;
      if (move_uploaded_file($tmp, $dest)){
        $mime = mime_content_type($dest) ?: '';
        $pdo->prepare("INSERT INTO task_comment_attachments (comment_id,type,source,file_name,file_path,mime_type,size,created_at)
                       VALUES (?,?,?,?,?,?,?,NOW())")
            ->execute([$comment_id,'upload','device',$name,$safe,$mime,$size]);
      }
    }
  }
}

// رابط خارجي اختياري
$external_url = trim($_POST['comment_external_url'] ?? '');
if ($external_url !== '') {
  $parsed = parse_url($external_url);
  $fileName = '';
  if (!empty($parsed['path'])) {
    $base = basename($parsed['path']);
    $fileName = $base !== '' ? $base : '';
  }
  if ($fileName === '') $fileName = $parsed['host'] ?? 'external-link';
  $pdo->prepare("INSERT INTO task_comment_attachments (comment_id,type,source,file_name,file_path,mime_type,size,created_at)
                 VALUES (?,?,?,?,?,'',0,NOW())")
      ->execute([$comment_id,'external','',$fileName,$external_url]);
}

header('Location: '.base_url('task_view.php?id='.$task_id)); exit;
