<?php
require_once __DIR__.'/../config/app.php';
require_once __DIR__.'/../config/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header("Location: ".base_url('login.php?err=no_post')); exit;
}
csrf_check();

$email    = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';

$stmt = $pdo->prepare("SELECT * FROM users WHERE email = ? LIMIT 1");
$stmt->execute([$email]);
$user = $stmt->fetch();

if ($user && password_verify($password, $user['password_hash'])) {
    $_SESSION['user_id']   = $user['id'];
    $_SESSION['user_role'] = $user['role'];
    $_SESSION['user_name'] = $user['name'];
    header("Location: ".base_url('dashboard.php')); exit;
}

// فشل الدخول → ارجع مع رسالة خطأ واضحة
header("Location: ".base_url('login.php?err=1')); exit;
