<?php
require_once "config/db.php";
include "includes/header.php";

$order_id = intval($_GET['order_id'] ?? 0);

if ($order_id > 0) {
    $sql = "SELECT o.*, 
                   p.name AS product_name, 
                   p.weight, 
                   u.name AS customer_name, 
                   u.email, 
                   u.phone
            FROM orders o
            LEFT JOIN products p ON o.product_id = p.id
            LEFT JOIN users u ON o.user_id = u.id
            WHERE o.id = ? LIMIT 1";
    $stmt = db()->prepare($sql);
    $stmt->execute([$order_id]);
    $order = $stmt->fetch();
}
?>

<main class="container">
  <div class="thankyou-box" style="text-align:center; margin:50px auto; padding:20px; border:1px solid #ddd; border-radius:8px;">
    <h2>✅ شكراً لك!</h2>
    <p>تم استلام طلبك بنجاح.</p>

    <?php if (!empty($order)): ?>
      <h3 style="margin-top:20px;">ملخص الطلب</h3>
      <table style="margin:20px auto; border-collapse:collapse; width:80%; text-align:center;">
        <tr style="background:#f8f8f8;">
          <th style="padding:10px; border:1px solid #ddd;">رقم الطلب</th>
          <th style="padding:10px; border:1px solid #ddd;">العميل</th>
          <th style="padding:10px; border:1px solid #ddd;">السبيكة</th>
          <th style="padding:10px; border:1px solid #ddd;">الوزن (جرام)</th>
          <th style="padding:10px; border:1px solid #ddd;">الكمية</th>
          <th style="padding:10px; border:1px solid #ddd;">الإجمالي (ريال)</th>
        </tr>
        <tr>
          <td style="padding:10px; border:1px solid #ddd;"><?= $order['id'] ?></td>
          <td style="padding:10px; border:1px solid #ddd;"><?= htmlspecialchars($order['customer_name']) ?></td>
          <td style="padding:10px; border:1px solid #ddd;"><?= htmlspecialchars($order['product_name']) ?></td>
          <td style="padding:10px; border:1px solid #ddd;"><?= $order['weight'] ?></td>
          <td style="padding:10px; border:1px solid #ddd;"><?= $order['quantity'] ?></td>
          <td style="padding:10px; border:1px solid #ddd;"><?= number_format($order['total'], 2) ?></td>
        </tr>
      </table>

      <!-- زر طباعة الفاتورة -->
      <a href="invoice.php?order_id=<?= $order['id'] ?>" target="_blank" 
         style="margin:10px; display:inline-block; padding:10px 20px; background:#28a745; color:#fff; border-radius:5px; text-decoration:none;">
         🖨️ طباعة الفاتورة
      </a>

    <?php else: ?>
      <p>⚠️ لم يتم العثور على تفاصيل الطلب.</p>
    <?php endif; ?>

    <a href="gold.php" class="btn" style="margin-top:20px; display:inline-block; padding:10px 20px; background:#6d2490; color:#fff; border-radius:5px; text-decoration:none;">
      🛒 متابعة التسوق
    </a>
  </div>
</main>

<?php include "includes/footer.php"; ?>
