<?php
// silver.php — بطاقات الفضة بنفس تنسيق الرئيسية + CSS داخلي
require_once __DIR__ . "/config/db.php";
require_once __DIR__ . "/config/price.php";
include_once __DIR__ . "/includes/header.php";

$pdo    = db();
$prices = getPrices();

// كل منتجات الفضة الفعّالة
$products = $pdo->query("
  SELECT id, name, description, image, weight, karat, status, metal
  FROM products
  WHERE status=1 AND metal='silver'
  ORDER BY id DESC
")->fetchAll(PDO::FETCH_ASSOC);

// مساعدين
function e($v): string { return htmlspecialchars((string)($v ?? ''), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
function product_img($path){
  $path = trim((string)$path);
  if ($path === '') return 'assets/img/placeholder-hero.jpg';
  $rel = (strpos($path,'uploads/')===0) ? $path : 'uploads/products/'.ltrim($path,'/');
  return is_file(__DIR__ . '/' . ltrim($rel,'/')) ? $rel : 'assets/img/placeholder-hero.jpg';
}
?>
<style>
/* ========== نفس تنسيق كروت الرئيسية بالضبط ========== */
.featured-products{padding:60px 0;width:90%;margin:0 auto}
.section-title{margin:0 0 20px;text-align:center;color:var(--text-color,#eaeaea);font-size:28px;position:relative}
.section-title:after{content:'';display:block;width:60px;height:3px;background:var(--primary-color,#d4af37);margin:10px auto;border-radius:10px}

.products-grid{display:grid;grid-template-columns:repeat(4,1fr);gap:24px}
@media(max-width:992px){.products-grid{grid-template-columns:repeat(2,1fr)}}
@media(max-width:576px){.products-grid{grid-template-columns:1fr}}

.product-card{position:relative;background:linear-gradient(180deg,#141414 0%,#0f0f0f 100%);
  border:1px solid rgba(212,175,55,.12);border-radius:14px;overflow:hidden;
  box-shadow:0 10px 22px rgba(0,0,0,.35);transform:translateZ(0);
  transition:transform .3s,box-shadow .3s,border-color .3s}
.product-card:hover{transform:translateY(-6px);box-shadow:0 16px 34px rgba(0,0,0,.45);border-color:rgba(212,175,55,.25)}

.product-card .img-wrap{position:relative;height:240px;background:#1b1b1b;overflow:hidden}
.product-card .img-wrap img{width:100%;height:100%;object-fit:cover;transition:transform .6s,filter .6s}
.product-card:hover .img-wrap img{transform:scale(1.06);filter:saturate(1.05)}

.product-badges{position:absolute;top:12px;inset-inline:12px auto;display:flex;gap:8px;z-index:2}
.badge{padding:6px 10px;border-radius:999px;font-size:12px;font-weight:700;color:#0f0f0f;
  background:linear-gradient(145deg,#b68f2a,#d4af37,#c8a951);box-shadow:inset 0 1px 0 rgba(255,255,255,.25)}

.product-info{padding:16px 16px 14px;display:flex;flex-direction:column;gap:10px}
.product-title{font-size:18px;margin:0;color:#eee}
.product-description{color:#9aa7b1;font-size:14px;line-height:1.75;margin:0}
.product-divider{height:1px;background:linear-gradient(90deg,transparent,rgba(212,175,55,.25),transparent);margin:6px 0 8px}

.product-price-container{display:flex;align-items:center;justify-content:space-between;gap:10px}
.product-price{font-weight:800;font-size:20px;background:linear-gradient(90deg,#b68f2a,#d4af37,#c8a951);
  -webkit-background-clip:text;background-clip:text;color:transparent}

.btn-gold,.btn-gold:link,.btn-gold:visited{text-decoration:none!important;display:inline-flex;align-items:center;gap:8px;
  padding:10px 16px;border-radius:10px;font-weight:800;color:#0f0f0f;background:linear-gradient(145deg,#b68f2a,#d4af37,#c8a951);
  box-shadow:0 10px 22px rgba(212,175,55,.22),inset 0 1px 0 rgba(255,255,255,.25);transition:transform .2s,box-shadow .2s,filter .2s}
.btn-gold:hover{transform:translateY(-2px);filter:saturate(1.05);box-shadow:0 14px 30px rgba(212,175,55,.28),inset 0 1px 0 rgba(255,255,255,.25)}
.btn-gold i{font-size:14px}
</style>

<section class="featured-products" dir="rtl">
  <h2 class="section-title">الفضة</h2>

  <div class="products-grid">
    <?php foreach ($products as $p): ?>
      <?php
        $wt   = (float)($p['weight'] ?? 0);
        $unit = (isset($prices['silver']) && is_numeric($prices['silver'])) ? (float)$prices['silver'] : 0.0; // ر.س/جم
        $price = $unit * $wt;

        $desc = trim((string)($p['description'] ?? ''));
        if ($desc !== '') {
          if (function_exists('mb_strimwidth')) {
            $desc = mb_strimwidth($desc, 0, 120, '...', 'UTF-8');
          } else {
            $desc = substr($desc, 0, 120) . (strlen($desc) > 120 ? '...' : '');
          }
        } else {
          $desc = 'لا يوجد وصف متاح';
        }

        $wtxt = $wt ? number_format($wt,2).' جم' : '';
        $img  = product_img($p['image'] ?? '');
        $title = (string)($p['name'] ?? '');
      ?>
      <article class="product-card">
        <div class="img-wrap">
          <div class="product-badges">
            <span class="badge">فضة</span>
            <?php if ($wt): ?><span class="badge"><?= e($wtxt) ?></span><?php endif; ?>
          </div>
          <img src="<?= e($img) ?>" alt="<?= e($title) ?>">
        </div>
        <div class="product-info">
          <h3 class="product-title"><?= e($title) ?></h3>
          <p class="product-description"><?= e($desc) ?></p>
          <div class="product-divider"></div>
          <div class="product-price-container">
            <span class="product-price"><?= number_format($price,2) ?> ر.س</span>
            <a href="product.php?id=<?= (int)$p['id'] ?>" class="btn-gold">التفاصيل <i class="fas fa-arrow-left"></i></a>
          </div>
        </div>
      </article>
    <?php endforeach; ?>

    <?php if (!$products): ?>
      <div style="grid-column:1/-1;color:#aaa;text-align:center">لا توجد منتجات فضة منشورة حالياً.</div>
    <?php endif; ?>
  </div>
</section>

<?php include_once __DIR__ . "/includes/footer.php"; ?>
