<?php
session_start();
require_once __DIR__ . "/config/db.php";

$error = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? "");
    $email = trim($_POST['email'] ?? "");
    $phone = trim($_POST['phone'] ?? "");
    $password = $_POST['password'] ?? "";
    $confirm = $_POST['confirm_password'] ?? "";

    if (!$name || !$email || !$phone || !$password) {
        $error = "⚠️ جميع الحقول مطلوبة";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = "⚠️ البريد الإلكتروني غير صالح";
    } elseif (!preg_match('/^05[0-9]{8}$/', $phone)) {
        $error = "⚠️ رقم الجوال غير صالح (مثال: 05xxxxxxxx)";
    } elseif ($password !== $confirm) {
        $error = "⚠️ كلمة المرور غير متطابقة";
    } else {
        // التحقق إذا البريد أو الجوال مستخدم مسبقًا
        $stmt = db()->prepare("SELECT id FROM users WHERE email=? OR phone=? LIMIT 1");
        $stmt->execute([$email, $phone]);
        if ($stmt->fetch()) {
            $error = "⚠️ البريد أو رقم الجوال مسجل مسبقًا";
        } else {
            $hashed = password_hash($password, PASSWORD_BCRYPT);
            $stmt = db()->prepare("INSERT INTO users (name, email, phone, password) VALUES (?, ?, ?, ?)");
            $stmt->execute([$name, $email, $phone, $hashed]);

            // تسجيل الدخول مباشرة بعد التسجيل
            $_SESSION['user_id'] = db()->lastInsertId();
            $_SESSION['user_name'] = $name;

            // إعادة التوجيه للصفحة المطلوبة أو الرئيسية
            if (isset($_SESSION['redirect_after_login'])) {
                $redirect = $_SESSION['redirect_after_login'];
                unset($_SESSION['redirect_after_login']);
                header("Location: " . $redirect);
                exit;
            }

            header("Location: index.php");
            exit;
        }
    }
}

include __DIR__ . "/includes/header.php";
?>

<section class="featured-products" style="text-align:center; padding:60px 20px;">
  <h2 class="section-title">إنشاء حساب جديد</h2>
  <?php if ($error): ?>
    <p style="color:red;"><?= $error ?></p>
  <?php endif; ?>
  <form method="post" style="max-width:400px; margin:20px auto; text-align:right;">
    <div style="margin-bottom:15px;">
      <label>الاسم الكامل</label>
      <input type="text" name="name" required style="width:100%; padding:10px;">
    </div>
    <div style="margin-bottom:15px;">
      <label>البريد الإلكتروني</label>
      <input type="email" name="email" required style="width:100%; padding:10px;">
    </div>
    <div style="margin-bottom:15px;">
      <label>رقم الجوال</label>
      <input type="text" name="phone" required style="width:100%; padding:10px;" placeholder="05xxxxxxxx">
    </div>
    <div style="margin-bottom:15px;">
      <label>كلمة المرور</label>
      <input type="password" name="password" required style="width:100%; padding:10px;">
    </div>
    <div style="margin-bottom:15px;">
      <label>تأكيد كلمة المرور</label>
      <input type="password" name="confirm_password" required style="width:100%; padding:10px;">
    </div>
    <button type="submit" class="btn">تسجيل</button>
  </form>

  <p style="margin-top:15px; font-size:14px;">
    هل لديك حساب؟ <a href="login.php" style="color:#ffd700; font-weight:bold;">تسجيل الدخول</a>
  </p>
</section>

<?php include __DIR__ . "/includes/footer.php"; ?>
