<?php
// partners.php
require_once __DIR__ . "/config/db.php";
include __DIR__ . "/includes/header.php";

/* --------- إعداد: إنشاء جدول رسائل التواصل إن لم يوجد --------- */
db()->exec("
CREATE TABLE IF NOT EXISTS contact_messages (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  email VARCHAR(160) DEFAULT NULL,
  phone VARCHAR(60) DEFAULT NULL,
  subject VARCHAR(200) DEFAULT NULL,
  message TEXT,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

/* --------- معالجة نموذج التواصل --------- */
$contact_ok = false; $contact_err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['__contact_token'])) {
  $name    = trim($_POST['name'] ?? '');
  $email   = trim($_POST['email'] ?? '');
  $phone   = trim($_POST['phone'] ?? '');
  $subject = trim($_POST['subject'] ?? '');
  $message = trim($_POST['message'] ?? '');

  if ($name === '' || $message === '') {
    $contact_err = 'الرجاء تعبئة الاسم والرسالة.';
  } else {
    $stmt = db()->prepare("INSERT INTO contact_messages(name,email,phone,subject,message) VALUES(?,?,?,?,?)");
    $stmt->execute([$name,$email,$phone,$subject,$message]);
    $contact_ok = true;

    /* (اختياري) إرسال إشعار بريد — عدّل البريد التالي ثم أزل التعليق:
    $to = 'info@example.com';
    @mail($to, "رسالة جديدة من الموقع: $subject",
      "الاسم: $name\nالبريد: $email\nالهاتف: $phone\n\nالرسالة:\n$message",
      "Content-Type: text/plain; charset=UTF-8");
    */
  }
}

/* --------- جلب شعارات الشركاء --------- */
/* إن كان لديك جدول partners (id,name,logo,url,status) سيُستخدم. خلاف ذلك نقرأ من uploads/partners */
$partners = [];
try {
  $partners = db()->query("SELECT name, logo, url FROM partners WHERE status=1 ORDER BY sort, id")->fetchAll();
} catch (Throwable $e) {
  // لا يوجد جدول partners — تجاهل
}
if (!$partners) {
  $dir = __DIR__ . '/uploads/partners';
  if (is_dir($dir)) {
    foreach (glob($dir.'/*.{png,jpg,jpeg,webp,svg}', GLOB_BRACE) as $p) {
      $rel = 'uploads/partners/' . basename($p);
      $partners[] = ['name' => pathinfo($p, PATHINFO_FILENAME), 'logo' => $rel, 'url' => ''];
    }
  }
}

/* --------- دالة ضبط مسار الصور --------- */
function fix_logo($path) {
  $path = trim((string)$path);
  if ($path === '') return 'assets/img/placeholder-hero.jpg';
  if (stripos($path,'http://')===0 || stripos($path,'https://')===0) return $path;
  $rel = (strpos($path,'/')===false) ? 'uploads/'.$path : $path;
  return is_file(__DIR__ . '/' . ltrim($rel,'/')) ? $rel : 'assets/img/placeholder-hero.jpg';
}
?>
<style>
/* فرض خط Cairo: */
@import url('https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700;800&display=swap');
html,body,button,input,select,textarea{font-family:'Cairo','Segoe UI',Tahoma,sans-serif!important}

/* ألوان ذهبية */
:root{
  --gold-1:#7a5c1e; --gold-2:#b68f2a; --gold-3:#d4af37; --gold-4:#c8a951;
}

/* ====== عنوان القسم العام ====== */
.section-wrap{width:90%;margin:0 auto;padding:50px 0}
.section-title{margin:0 0 20px;text-align:center;color:var(--text-color);font-size:28px;position:relative}
.section-title:after{content:'';display:block;width:60px;height:3px;background:var(--primary-color);margin:10px auto;border-radius:10px}

/* ====== سلايدر شعارات شركاؤنا (ثيم داكن وحد ذهبي) ====== */
.partners-bar{
  background:linear-gradient(180deg,#121212 0%, #0f0f0f 100%);
  border:1px solid rgba(212,175,55,.45);
  border-radius:16px; padding:18px 14px;
  box-shadow:0 14px 30px rgba(0,0,0,.35);
  position:relative; overflow:hidden;
}
.logo-track{
  display:flex; align-items:center; gap:36px;
  min-width:100%; will-change:transform;
  animation: logos-roll 28s linear infinite;
}
.logo-track:hover{ animation-play-state: paused; }
.logo-item{
  flex:0 0 auto; width:160px; height:86px; border-radius:12px;
  background:#0f0f0f; border:1px solid rgba(212,175,55,.25);
  display:grid; place-items:center; padding:10px; transition:.25s; filter:grayscale(20%);
}
.logo-item:hover{ filter:none; transform:translateY(-4px); box-shadow:0 10px 24px rgba(0,0,0,.35), inset 0 1px 0 rgba(255,255,255,.08);}
.logo-item img{max-width:100%; max-height:100%; object-fit:contain}

/* تكرار المسار لتأثير لا نهائي */
@keyframes logos-roll{
  from{ transform: translateX(0); }
  to{ transform: translateX(-50%); }
}

/* أسهم يدوية */
.partners-prev,.partners-next{
  position:absolute; top:50%; transform:translateY(-50%);
  width:40px;height:40px;border-radius:50%;border:0;cursor:pointer;
  background:rgba(0,0,0,.45); color:#fff; display:flex;align-items:center;justify-content:center;
  transition:.2s; z-index:2;
}
.partners-prev{right:10px} .partners-next{left:10px}
.partners-prev:hover,.partners-next:hover{background:rgba(0,0,0,.65)}

/* ====== شبكة تواصل: نموذج + بطاقة ====== */
.contact-grid{
  display:grid; grid-template-columns: 2fr 1fr; gap:22px;
}
@media (max-width: 900px){ .contact-grid{ grid-template-columns: 1fr; } }

.card{
  background:linear-gradient(180deg,#121212 0%,#0f0f0f 100%);
  border:1px solid rgba(212,175,55,.45);
  border-radius:16px; padding:18px; box-shadow:0 14px 30px rgba(0,0,0,.35);
}

/* نموذج تواصل */
.form-row{display:grid; grid-template-columns: 1fr 1fr; gap:12px}
@media (max-width:600px){ .form-row{ grid-template-columns:1fr; } }
.field{position:relative}
.field i{
  position:absolute; right:12px; top:50%; transform:translateY(-50%);
  color:var(--primary-color); opacity:.9;
}
.input, .textarea{
  width:100%; background:#0b0b0b; color:#eaeaea;
  border:1px solid rgba(212,175,55,.35); border-radius:12px;
  padding:12px 40px 12px 12px; outline:0; transition:.2s;
}
.input:focus,.textarea:focus{ border-color: var(--primary-color); box-shadow: 0 0 0 3px rgba(212,175,55,.15); }
.textarea{ min-height:130px; resize:vertical }

.btn-gold, .btn-gold:link, .btn-gold:visited{
  text-decoration:none!important;
  display:inline-flex; align-items:center; gap:8px; padding:12px 18px;
  border-radius:12px; font-weight:800; color:#0f0f0f; cursor:pointer;
  background: linear-gradient(145deg, var(--gold-2), var(--gold-3), var(--gold-4));
  box-shadow: 0 12px 28px rgba(212,175,55,.25), inset 0 1px 0 rgba(255,255,255,.25);
  border:0; transition: transform .2s, box-shadow .2s, filter .2s;
}
.btn-gold:hover{ transform: translateY(-2px); filter:saturate(1.05); box-shadow: 0 16px 36px rgba(212,175,55,.32), inset 0 1px 0 rgba(255,255,255,.25); }

/* بطاقة بيانات الاتصال */
.info-list{list-style:none; padding:0; margin:0; display:flex; flex-direction:column; gap:12px}
.info-item{display:flex; align-items:center; gap:12px; color:#eaeaea}
.info-item .ico{
  width:40px;height:40px;border-radius:10px; display:grid; place-items:center;
  background: linear-gradient(145deg, var(--gold-2), var(--gold-3)); color:#0f0f0f;
  box-shadow: inset 0 1px 0 rgba(255,255,255,.3);
}
.info-actions{display:flex; gap:10px; margin-top:14px; flex-wrap:wrap}
.info-actions a{ text-decoration:none!important; }

/* تنبيه النموذج */
.alert{border-radius:10px;padding:10px 12px;margin-bottom:12px;font-weight:600}
.alert-ok{background:#112d1a;border:1px solid #1f7a33;color:#b8f7c8}
.alert-err{background:#3f1d1d;border:1px solid #7f1d1d;color:#fee2e2}
</style>

<!-- ===== شركاؤنا ===== -->
<section class="section-wrap" dir="rtl">
  <h2 class="section-title">شركاؤنا</h2>

  <div class="partners-bar" id="partnersBar">
    <button class="partners-prev" id="partnersPrev" aria-label="السابق"><i class="fas fa-chevron-right"></i></button>
    <button class="partners-next" id="partnersNext" aria-label="التالي"><i class="fas fa-chevron-left"></i></button>

    <?php
      // نكرّر القائمة مرتين لعمل مسار لا نهائي
      $logos = $partners ?: [];
      $logos2 = array_merge($logos, $logos);
    ?>
    <div class="logo-track" id="logoTrack">
      <?php foreach ($logos2 as $it): ?>
        <?php $src = fix_logo($it['logo'] ?? ''); $name = htmlspecialchars($it['name'] ?? ''); $url = trim($it['url'] ?? ''); ?>
        <?php if ($url !== ''): ?>
          <a class="logo-item" href="<?= htmlspecialchars($url) ?>" target="_blank" rel="noopener" title="<?= $name ?>">
            <img src="<?= htmlspecialchars($src) ?>" alt="<?= $name ?>">
          </a>
        <?php else: ?>
          <div class="logo-item" title="<?= $name ?>">
            <img src="<?= htmlspecialchars($src) ?>" alt="<?= $name ?>">
          </div>
        <?php endif; ?>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- ===== تواصل معنا ===== -->
<section class="section-wrap" dir="rtl">
  <h2 class="section-title">تواصل معنا</h2>

  <div class="contact-grid">
    <!-- نموذج -->
    <div class="card">
      <?php if ($contact_ok): ?>
        <div class="alert alert-ok">شكرًا لك! تم استلام رسالتك وسنعاود التواصل قريبًا.</div>
      <?php elseif ($contact_err): ?>
        <div class="alert alert-err"><?= htmlspecialchars($contact_err) ?></div>
      <?php endif; ?>

      <form method="post" novalidate>
        <input type="hidden" name="__contact_token" value="<?= bin2hex(random_bytes(6)) ?>">
        <div class="form-row">
          <div class="field">
            <i class="fas fa-user"></i>
            <input class="input" type="text" name="name" placeholder="الاسم*" required>
          </div>
          <div class="field">
            <i class="fas fa-envelope"></i>
            <input class="input" type="email" name="email" placeholder="البريد الإلكتروني">
          </div>
        </div>
        <div class="form-row" style="margin-top:12px">
          <div class="field">
            <i class="fas fa-phone"></i>
            <input class="input" type="text" name="phone" placeholder="رقم الجوال">
          </div>
          <div class="field">
            <i class="fas fa-tag"></i>
            <input class="input" type="text" name="subject" placeholder="الموضوع">
          </div>
        </div>
        <div class="field" style="margin-top:12px">
          <i class="fas fa-comment-dots" style="top:18px"></i>
          <textarea class="textarea" name="message" placeholder="اكتب رسالتك هنا*" required></textarea>
        </div>
        <div style="margin-top:14px; display:flex; gap:10px; align-items:center">
          <button class="btn-gold" type="submit"><i class="fas fa-paper-plane"></i> إرسال الرسالة</button>
          <small style="color:#9aa7b1">* الحقول الإلزامية</small>
        </div>
      </form>
    </div>

    <!-- بطاقة بيانات التواصل -->
    <aside class="card">
      <h3 style="margin:0 0 12px; color:var(--primary-color); font-size:20px">بيانات التواصل</h3>
      <ul class="info-list">
        <li class="info-item"><span class="ico"><i class="fas fa-phone"></i></span> <a href="tel:+966500000000" style="color:#eaeaea; text-decoration:none">+966 50 000 0000</a></li>
        <li class="info-item"><span class="ico"><i class="fab fa-whatsapp"></i></span> <a href="https://wa.me/966500000000" target="_blank" style="color:#eaeaea; text-decoration:none">واتساب مباشر</a></li>
        <li class="info-item"><span class="ico"><i class="fas fa-envelope"></i></span> <a href="mailto:info@example.com" style="color:#eaeaea; text-decoration:none">info@example.com</a></li>
        <li class="info-item"><span class="ico"><i class="fas fa-location-dot"></i></span> جدة ـ المملكة العربية السعودية</li>
        <li class="info-item"><span class="ico"><i class="fas fa-clock"></i></span> 9 صباحًا – 10 مساءً (يوميًا)</li>
      </ul>
      <div class="info-actions">
        <a class="btn-gold" href="https://maps.google.com/?q=Jeddah" target="_blank"><i class="fas fa-map-location-dot"></i> فتح الخريطة</a>
        <a class="btn-gold" href="contact.php"><i class="fas fa-envelope-open-text"></i> صفحة التواصل</a>
      </div>
    </aside>
  </div>
</section>

<script>
/* أسهم سلايدر الشركاء — إزاحة يدوية */
(function(){
  const track = document.getElementById('logoTrack');
  const prev  = document.getElementById('partnersPrev');
  const next  = document.getElementById('partnersNext');
  let offset = 0;

  function nudge(dir){
    // كل نقرة تحرك ~ 220px مع الحفاظ على اللفّ اللانهائي
    offset += dir * 220;
    track.style.transition = 'transform .35s ease';
    track.style.transform  = `translateX(${offset}px)`;
    clearTimeout(track._reset);
    track._reset = setTimeout(()=>{
      // بعد التحريك اليدوي نعيد الحركة التلقائية
      track.style.transition = '';
      track.style.transform  = '';
      offset = 0;
    }, 800);
  }
  prev && prev.addEventListener('click', ()=> nudge( +1 ));
  next && next.addEventListener('click', ()=> nudge( -1 ));
})();
</script>

<?php include __DIR__ . "/includes/footer.php"; ?>
