<?php
session_start();
require_once __DIR__ . "/config/db.php";
include __DIR__ . "/includes/header.php";

// نفترض أن المستخدم مسجل دخول
if (!isset($_SESSION['user_id'])) {
    echo "<p style='text-align:center; padding:50px;'>⚠️ الرجاء تسجيل الدخول لمشاهدة طلباتك</p>";
    include __DIR__ . "/includes/footer.php";
    exit;
}

$user_id = $_SESSION['user_id'];

// جلب الطلبات
$stmt = db()->prepare("SELECT * FROM orders WHERE user_id=? ORDER BY created_at DESC");
$stmt->execute([$user_id]);
$orders = $stmt->fetchAll();
?>

<section class="featured-products">
  <h2 class="section-title">📋 طلباتي</h2>

  <?php if (!$orders): ?>
    <p style="text-align:center; padding:30px;">لا توجد طلبات حتى الآن.</p>
  <?php else: ?>
    <div class="products-grid">
      <?php foreach ($orders as $o): ?>
        <div class="product-card">
          <div class="product-info">
            <h3 class="product-title">طلب رقم #<?= $o['id'] ?></h3>
            <ul class="product-features">
              <li>التاريخ: <?= $o['created_at'] ?></li>
              <li>الحالة: <?= htmlspecialchars($o['status']) ?></li>
              <li>الإجمالي: <?= number_format($o['total'], 2) ?> ر.س</li>
              <?php if ($o['receipt']): ?>
                <li>الإيصال: 
                  <a href="uploads/receipts/<?= htmlspecialchars($o['receipt']) ?>" target="_blank">عرض</a>
                </li>
              <?php endif; ?>
            </ul>
            <div class="product-divider"></div>
            <div class="product-price-container">
              <a href="order_view.php?id=<?= $o['id'] ?>" class="details-btn">عرض التفاصيل</a>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</section>

<?php include __DIR__ . "/includes/footer.php"; ?>
