<?php
session_start();
require_once __DIR__ . "/config/db.php";

$error = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login = trim($_POST['login'] ?? ""); // بريد أو جوال
    $password = $_POST['password'] ?? "";

    // التحقق هل المدخل بريد أم جوال
    if (filter_var($login, FILTER_VALIDATE_EMAIL)) {
        $stmt = db()->prepare("SELECT * FROM users WHERE email=? LIMIT 1");
    } else {
        $stmt = db()->prepare("SELECT * FROM users WHERE phone=? LIMIT 1");
    }
    $stmt->execute([$login]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user_name'] = $user['name'];

        // إعادة التوجيه للصفحة المطلوبة قبل تسجيل الدخول
        if (isset($_SESSION['redirect_after_login'])) {
            $redirect = $_SESSION['redirect_after_login'];
            unset($_SESSION['redirect_after_login']);
            header("Location: " . $redirect);
            exit;
        }

        header("Location: index.php");
        exit;
    } else {
        $error = "❌ بيانات الدخول غير صحيحة";
    }
}

include __DIR__ . "/includes/header.php";
?>

<section class="featured-products" style="text-align:center; padding:60px 20px;">
  <h2 class="section-title">تسجيل الدخول</h2>

  <?php if (isset($_GET['msg']) && $_GET['msg'] === 'login_required'): ?>
    <p style="color:orange;">⚠️ الرجاء تسجيل الدخول لإتمام طلبك</p>
  <?php endif; ?>

  <?php if ($error): ?>
    <p style="color:red;"><?= $error ?></p>
  <?php endif; ?>

  <form method="post" style="max-width:400px; margin:20px auto; text-align:right;">
    <div style="margin-bottom:15px;">
      <label>البريد الإلكتروني أو الجوال</label>
      <input type="text" name="login" required style="width:100%; padding:10px;">
    </div>
    <div style="margin-bottom:15px;">
      <label>كلمة المرور</label>
      <input type="password" name="password" required style="width:100%; padding:10px;">
    </div>
    <button type="submit" class="btn">دخول</button>
  </form>

  <p style="margin-top:15px; font-size:14px;">
    ليس لديك حساب؟ <a href="register.php" style="color:#ffd700; font-weight:bold;">إنشاء حساب جديد</a>
  </p>
</section>

<?php include __DIR__ . "/includes/footer.php"; ?>
