<?php
// includes/auth.php
if (session_status() === PHP_SESSION_NONE) session_start();

$root = dirname(__DIR__); // /home/.../public_html/alkindi

// المرشح الأساسي (المطلوب توفره)
$primary = $root . '/config/db.php';
// احتياطي (في حال عندك نسخة قديمة)
$legacy  = $root . '/config/config.php';

if (is_file($primary)) {
  require_once $primary;
} elseif (is_file($legacy)) {
  require_once $legacy; // يمكن أن يحيل داخليًا إلى db.php
} else {
  // سجّل للمخدم فقط ولا تكشف المسارات للزائر
  error_log("auth.php: No config file found. Tried: $primary , $legacy");
  http_response_code(500);
  exit('Database config file is missing.'); // رسالة واضحة
}

/* اجعل تسجيل الدخول اختياري هنا (فعّل التحويل عند تجهيز صفحة login) */
function require_login() {
  if (empty($_SESSION['user_id'])) {
    // header('Location: ../login.php'); exit;
  }
}
