<?php
// contact.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once __DIR__ . "/config/db.php";
include __DIR__ . "/includes/header.php";


/* إنشاء جدول الرسائل إن لم يوجد */
db()->exec("
CREATE TABLE IF NOT EXISTS contact_messages (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(120) NOT NULL,
  email VARCHAR(160) DEFAULT NULL,
  phone VARCHAR(60) DEFAULT NULL,
  subject VARCHAR(200) DEFAULT NULL,
  message TEXT,
  created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
");

$ok = false; $err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['csrf']) && hash_equals($csrf, $_POST['csrf'])) {
  // حقل مصيدة بوت (honeypot)
  if (!empty($_POST['website'])) {
    $err = 'تم رفض الإرسال (تحقق مكافحة السبام).';
  } else {
    $name    = trim($_POST['name'] ?? '');
    $email   = trim($_POST['email'] ?? '');
    $phone   = trim($_POST['phone'] ?? '');
    $subject = trim($_POST['subject'] ?? '');
    $message = trim($_POST['message'] ?? '');

    if ($name === '' || $message === '') {
      $err = 'الرجاء تعبئة الاسم والرسالة على الأقل.';
    } else {
      $stmt = db()->prepare("INSERT INTO contact_messages (name,email,phone,subject,message) VALUES (?,?,?,?,?)");
      $stmt->execute([$name,$email,$phone,$subject,$message]);
      $ok = true;

      // (اختياري) إرسال بريد تنبيهي للإدارة — فعّل حسب الحاجة:
      // @mail('admin@example.com', 'رسالة جديدة من نموذج تواصل', "الاسم: $name\nالبريد: $email\nالجوال: $phone\nالموضوع: $subject\n\nالرسالة:\n$message");
    }
  }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>تواصل معنا | الكندي للذهب والمجوهرات</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

<style>
/* ==== Cairo + ثيم عام ==== */
@import url('https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700;800&display=swap');
:root{
  --primary-color:#D4AF37;
  --text:#e0e0e0;
  --muted:#9aa7b1;
  --bg:#0a0a0a; --card:#121212; --line:#232323;
  --gold-2:#b68f2a; --gold-3:#d4af37; --gold-4:#c8a951;
}
html,body,button,input,select,textarea{font-family:'Cairo','Segoe UI',Tahoma,Geneva,Verdana,sans-serif!important}
body{background:var(--bg);color:var(--text)}

/* ==== HERO داخلي ==== */
.inner-hero{position:relative;overflow:hidden;height:300px;background:#000;margin-top:0}
.inner-hero::before{content:"";position:absolute;inset:0;background:url('assets/img/contact-hero.jpg') center/cover no-repeat, #000;filter:brightness(.8) contrast(1.05) saturate(1.05)}
.inner-hero::after{content:"";position:absolute;inset:0;background:radial-gradient(60% 80% at 50% 50%, rgba(0,0,0,.45), rgba(0,0,0,.75))}
.inner-hero .content{position:relative;z-index:2;height:100%;display:flex;flex-direction:column;align-items:center;justify-content:center;text-align:center;padding:0 18px}
.inner-hero h1{margin:8px 0 6px;font-size:36px;font-weight:900;background:linear-gradient(90deg,var(--gold-2),var(--gold-3),var(--gold-4));-webkit-background-clip:text;background-clip:text;color:transparent}
.inner-hero p{margin:0;color:#eee;max-width:820px;line-height:1.85}

/* ==== حاوية ==== */
.section{width:90%;margin:0 auto;padding:48px 0}
.section-title{text-align:center;margin:0 0 16px;font-weight:800;letter-spacing:.2px;font-size:26px}
.section-title::after{content:"";display:block;width:64px;height:3px;background:var(--primary-color);margin:10px auto;border-radius:8px}
.section-sub{text-align:center;color:var(--muted);margin:0 auto 22px;max-width:800px}

/* ==== Grid التواصل ==== */
.grid{display:grid;grid-template-columns:2fr 1fr;gap:18px}
@media (max-width:900px){.grid{grid-template-columns:1fr}}
.card{background:linear-gradient(180deg,#121212 0%,#0f0f0f 100%);border:1px solid rgba(212,175,55,.45);border-radius:16px;padding:18px;box-shadow:0 14px 30px rgba(0,0,0,.35)}

/* ==== النموذج ==== */
.form-row{display:grid;grid-template-columns:1fr 1fr;gap:12px}
@media (max-width:600px){.form-row{grid-template-columns:1fr}}
.field{position:relative}
.field i{position:absolute;right:12px;top:50%;transform:translateY(-50%);color:var(--primary-color);opacity:.9}
.input,.textarea{width:100%;background:#0b0b0b;color:#eaeaea;border:1px solid rgba(212,175,55,.35);border-radius:12px;padding:12px 40px 12px 12px;outline:0;transition:.2s}
.input:focus,.textarea:focus{border-color:var(--primary-color);box-shadow:0 0 0 3px rgba(212,175,55,.15)}
.textarea{min-height:150px;resize:vertical}
.btn-gold{display:inline-flex;align-items:center;gap:8px;padding:12px 18px;border-radius:12px;font-weight:800;color:#0f0f0f;background:linear-gradient(145deg,var(--gold-2),var(--gold-3),var(--gold-4));box-shadow:0 12px 28px rgba(212,175,55,.25),inset 0 1px 0 rgba(255,255,255,.25);border:0;cursor:pointer;transition:transform .2s,filter .2s,box-shadow .2s}
.btn-gold:hover{transform:translateY(-2px);filter:saturate(1.05);box-shadow:0 16px 36px rgba(212,175,55,.32)}
.small{color:var(--muted);font-size:12px}
.alert{border-radius:10px;padding:10px 12px;margin-bottom:12px;font-weight:600}
.alert-ok{background:#112d1a;border:1px solid #1f7a33;color:#b8f7c8}
.alert-err{background:#3f1d1d;border:1px solid #7f1d1d;color:#fee2e2}

/* ==== بطاقة بيانات التواصل ==== */
.info h3{margin:0 0 10px;color:var(--primary-color);font-size:20px}
.info-list{list-style:none;padding:0;margin:0;display:flex;flex-direction:column;gap:12px}
.info-item{display:flex;align-items:center;gap:12px;color:#eaeaea}
.info-item .ico{width:40px;height:40px;border-radius:10px;display:grid;place-items:center;background:linear-gradient(145deg,var(--gold-2),var(--gold-3));color:#0f0f0f;box-shadow:inset 0 1px 0 rgba(255,255,255,.3)}
.info-actions{display:flex;gap:10px;margin-top:14px;flex-wrap:wrap}
.info-actions a{text-decoration:none!important}

/* ==== الخريطة ==== */
.map-card .frame{width:100%;height:360px;border:0;border-radius:14px;filter:grayscale(10%) contrast(1.05)}
@media (max-width:600px){.map-card .frame{height:280px}}

/* ==== تأثير ظهور ==== */
.reveal{opacity:0;transform:translateY(18px) scale(.98);transition:opacity .6s ease,transform .6s ease}
.reveal.visible{opacity:1;transform:translateY(0) scale(1)}
/* ==== Hotfix لمنع الشريط الأفقي ==== */
html, body { max-width: 100%; overflow-x: hidden; }
*, *::before, *::after { box-sizing: border-box; }
img, video, canvas, svg, iframe { max-width: 100%; height: auto; display: block; }

.section, .card, .grid { max-width: 100%; overflow-x: hidden; }

/* تأكيد تغطية الهيرو دون تمدّد */
.inner-hero,
.inner-hero::before,
.inner-hero::after { left: 0; right: 0; width: 100%; }

/* خريطة جوجل أحيانًا تسبب تمدّد نصف بكسل */
.map-card { overflow: hidden; }
.map-card .frame { width: 100% !important; border: 0; display: block; }

/* منع كلمات/روابط طويلة من دفع العرض */
p, a, .textarea, .input { overflow-wrap: anywhere; word-break: break-word; }
</style>
</style>
</head>
<body>

<!-- HERO -->
<section class="inner-hero">
  <div class="content">
    <h1>تواصل معنا</h1>
    <p>يسعدنا استقبال استفساراتك واقتراحاتك — فريقنا جاهز للرد بخدمة راقية وسريعة.</p>
  </div>
</section>

<!-- نموذج + بيانات -->
<section class="section">
  <h2 class="section-title">راسلنا</h2>
  <p class="section-sub">املأ الحقول التالية وسنعاود التواصل معك في أقرب وقت ممكن.</p>

  <div class="grid">
    <!-- النموذج -->
    <div class="card reveal">
      <?php if ($ok): ?><div class="alert alert-ok"><i class="fa-solid fa-circle-check"></i> شكرًا لك! تم استلام رسالتك بنجاح.</div><?php endif; ?>
      <?php if ($err): ?><div class="alert alert-err"><i class="fa-solid fa-triangle-exclamation"></i> <?= htmlspecialchars($err) ?></div><?php endif; ?>

      <form method="post" novalidate>
        <input type="hidden" name="csrf" value="<?= $csrf ?>">
        <!-- honeypot -->
        <input type="text" name="website" style="position:absolute;left:-9999px;opacity:0" tabindex="-1" autocomplete="off">

        <div class="form-row">
          <div class="field">
            <i class="fa-solid fa-user"></i>
            <input class="input" type="text" name="name" placeholder="الاسم الكامل *" required>
          </div>
          <div class="field">
            <i class="fa-solid fa-envelope"></i>
            <input class="input" type="email" name="email" placeholder="البريد الإلكتروني (اختياري)">
          </div>
        </div>

        <div class="form-row" style="margin-top:12px">
          <div class="field">
            <i class="fa-solid fa-phone"></i>
            <input class="input" type="text" name="phone" placeholder="رقم الجوال (اختياري)">
          </div>
          <div class="field">
            <i class="fa-solid fa-tag"></i>
            <input class="input" type="text" name="subject" placeholder="الموضوع (اختياري)">
          </div>
        </div>

        <div class="field" style="margin-top:12px">
          <i class="fa-solid fa-comment-dots" style="top:18px"></i>
          <textarea class="textarea" name="message" placeholder="نص الرسالة *" required></textarea>
        </div>

        <div style="margin-top:14px;display:flex;align-items:center;gap:10px;flex-wrap:wrap">
          <button class="btn-gold" type="submit"><i class="fa-solid fa-paper-plane"></i> إرسال</button>
          <span class="small">* الحقول الإلزامية</span>
        </div>
      </form>
    </div>

    <!-- بيانات التواصل -->
    <aside class="card info reveal">
      <h3>بيانات التواصل</h3>
      <ul class="info-list">
        <li class="info-item"><span class="ico"><i class="fa-solid fa-phone"></i></span> <a href="tel:+966500000000" style="color:#eaeaea;text-decoration:none">+966 50 000 0000</a></li>
        <li class="info-item"><span class="ico"><i class="fa-brands fa-whatsapp"></i></span> <a href="https://wa.me/966500000000" target="_blank" style="color:#eaeaea;text-decoration:none">واتساب مباشر</a></li>
        <li class="info-item"><span class="ico"><i class="fa-solid fa-envelope"></i></span> <a href="mailto:info@example.com" style="color:#eaeaea;text-decoration:none">info@example.com</a></li>
        <li class="info-item"><span class="ico"><i class="fa-solid fa-location-dot"></i></span> جدة — المملكة العربية السعودية</li>
        <li class="info-item"><span class="ico"><i class="fa-solid fa-clock"></i></span> 9 صباحًا – 10 مساءً (يوميًا)</li>
      </ul>
      <div class="info-actions">
        <a class="btn-gold" href="https://maps.google.com/?q=Jeddah" target="_blank"><i class="fa-solid fa-map-location-dot"></i> فتح الخريطة</a>
        <a class="btn-gold" href="tel:+966500000000"><i class="fa-solid fa-phone-volume"></i> اتصال سريع</a>
      </div>
    </aside>
  </div>
</section>

<!-- خريطة -->
<section class="section">
  <h2 class="section-title">موقعنا</h2>
  <p class="section-sub">يسعدنا زيارتكم في فرعنا — ستجدوننا بسهولة عبر الخريطة التالية.</p>
  <div class="card map-card reveal">
    <!-- يمكنك استبدال src بإحداثيات موقعك على Google Maps Embed -->
    <iframe class="frame"
      src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3687.743704819043!2d39.197971!3d21.485811!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x15c3d7b5f3f0f1e9%3A0x0000000000000000!2sJeddah!5e0!3m2!1sar!2ssa!4v1700000000000"
      allowfullscreen=""
      loading="lazy"
      referrerpolicy="no-referrer-when-downgrade"></iframe>
  </div>
</section>

<script>
/* ظهور عند التمرير */
(function(){
  const els=[...document.querySelectorAll('.reveal')];
  if(!('IntersectionObserver' in window)){ els.forEach(e=>e.classList.add('visible')); return; }
  const io=new IntersectionObserver((ents)=>{
    ents.forEach(en=>{
      if(en.isIntersecting){ en.target.classList.add('visible'); io.unobserve(en.target); }
    });
  },{threshold:.18});
  els.forEach(e=>io.observe(e));
})();
</script>

<?php include __DIR__ . "/includes/footer.php"; ?>
</body>
</html>
