<?php
require_once __DIR__ . "/config/db.php";
include __DIR__ . "/includes/header.php";

$perPage = 9;
$page = max(1, (int)($_GET['page'] ?? 1));
$offset = ($page - 1) * $perPage;

$total = db()->query("SELECT COUNT(*) FROM blog_posts WHERE status=1")->fetchColumn();
$stmt  = db()->prepare("SELECT id,title,summary,image,created_at FROM blog_posts WHERE status=1 ORDER BY created_at DESC, id DESC LIMIT :l OFFSET :o");
$stmt->bindValue(':l', $perPage, PDO::PARAM_INT);
$stmt->bindValue(':o', $offset, PDO::PARAM_INT);
$stmt->execute();
$posts = $stmt->fetchAll();

function fix_image_url($p){
  $p = trim((string)$p);
  if ($p !== '' && (stripos($p,'http://')===0 || stripos($p,'https://')===0 || stripos($p,'data:')===0)) return $p;
  if ($p !== '' && strpos($p,'/')===false) $p = 'uploads/'.$p;
  $abs = __DIR__ . '/' . ltrim($p,'/');
  return is_file($abs) ? $p : 'assets/img/placeholder-hero.jpg';
}
$pages = max(1, ceil($total / $perPage));
?>
<style>
/* ===== فرض خط Cairo داخل نطاق المدونة فقط ===== */
.blog-wrap, .blog-wrap * {
  font-family: 'Cairo','Segoe UI',Tahoma,Geneva,Verdana,sans-serif !important;
}

/* تصميم المدونة */
.blog-wrap{width:90%;margin:40px auto}
.blog-grid{display:grid;grid-template-columns:repeat(3,1fr);gap:22px}
.blog-card{background:var(--card-color);border-radius:8px;overflow:hidden;box-shadow:0 4px 15px rgba(0,0,0,.3);display:flex;flex-direction:column}
.blog-card .thumb{height:200px;background:#222;overflow:hidden}
.blog-card .thumb img{width:100%;height:100%;object-fit:cover;transition:transform .5s}
.blog-card:hover .thumb img{transform:scale(1.06)}
.blog-card .body{padding:16px;display:flex;flex-direction:column;gap:8px;flex:1}
.blog-card h3{font-size:20px;margin:0;color:var(--text-color)}
.blog-card p{color:var(--dark-gray);font-size:14px;line-height:1.7;margin:0}
.blog-card .meta{font-size:12px;color:#aaa;margin-top:auto}
.blog-card .more{margin:12px 16px 16px auto}
.pager{display:flex;gap:8px;justify-content:center;margin:24px 0}
.pager a,.pager span{padding:8px 12px;border:1px solid var(--light-gray);border-radius:6px;text-decoration:none;color:var(--text-color)}
.pager .on{background:var(--primary-color);color:#000;border-color:var(--primary-color)}
@media(max-width:992px){.blog-grid{grid-template-columns:repeat(2,1fr)}}
@media(max-width:576px){.blog-grid{grid-template-columns:1fr}}
</style>

<section class="blog-wrap">
  <h2 class="section-title">المدونة</h2>
  <div class="blog-grid">
    <?php foreach ($posts as $b): ?>
      <?php $img = fix_image_url($b['image'] ?? ''); ?>
      <article class="blog-card">
        <div class="thumb"><img src="<?= htmlspecialchars($img) ?>" alt="<?= htmlspecialchars($b['title']) ?>"></div>
        <div class="body">
          <h3><?= htmlspecialchars($b['title']) ?></h3>
          <p><?= htmlspecialchars(mb_strimwidth((string)$b['summary'],0,160,'...','UTF-8')) ?></p>
          <div class="meta"><i class="far fa-calendar"></i> <?= date('Y-m-d', strtotime($b['created_at'])) ?></div>
        </div>
        <div class="more">
          <a href="blog_view.php?id=<?= (int)$b['id'] ?>" class="details-btn">اقرأ المزيد</a>
        </div>
      </article>
    <?php endforeach; ?>
    <?php if (!$posts): ?>
      <div style="grid-column: 1/-1; color:#aaa">لا توجد مقالات منشورة حالياً.</div>
    <?php endif; ?>
  </div>

  <?php if ($pages > 1): ?>
    <div class="pager">
      <?php for ($i=1;$i<=$pages;$i++): ?>
        <?php if ($i == $page): ?>
          <span class="on"><?= $i ?></span>
        <?php else: ?>
          <a href="?page=<?= $i ?>"><?= $i ?></a>
        <?php endif; ?>
      <?php endfor; ?>
    </div>
  <?php endif; ?>
</section>

<?php include __DIR__ . "/includes/footer.php"; ?>
