async function updateMetalPrices() {
    try {
        const response = await fetch("config/price.php?json=1");
        const data = await response.json();

        // تحديث الشريط العلوي
        const goldEl = document.getElementById("gold-price");
        const silverEl = document.getElementById("silver-price");

        if (goldEl) goldEl.textContent = data.gold_24.toFixed(2);
        if (silverEl) silverEl.textContent = data.silver.toFixed(2);

        // تحديث أسعار المنتجات
        const productPrices = document.querySelectorAll(".product-price");
        if (productPrices.length > 0) {
            productPrices.forEach(priceElement => {
                const basePrice = parseFloat(priceElement.getAttribute("data-base-price"));
                const karat = priceElement.getAttribute("data-karat");
                let unitPrice = 0;

                if (karat === "24") unitPrice = data.gold_24;
                else if (karat === "21") unitPrice = data.gold_21;
                else if (karat === "18") unitPrice = data.gold_18;
                else if (karat === "silver") unitPrice = data.silver;

                if (!isNaN(basePrice) && unitPrice > 0) {
                    const newPrice = unitPrice * basePrice;
                    priceElement.textContent = newPrice.toLocaleString("ar-SA", {
                        maximumFractionDigits: 2
                    }) + " ر.س";
                }
            });
        }
    } catch (error) {
        console.error("خطأ في جلب الأسعار:", error);
    }
}

// تشغيل التحديث كل 60 ثانية
setInterval(updateMetalPrices, 60000);
document.addEventListener("DOMContentLoaded", updateMetalPrices);
