<?php
require_once "../config/db.php";
require_once "../includes/auth.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $order_id = intval($_POST['order_id'] ?? 0);
    $status   = trim($_POST['status'] ?? "");

    // التحقق من صحة البيانات
    if ($order_id > 0 && in_array($status, ['معلق','مكتمل','ملغي','تم الشحن'])) {
        $stmt = db()->prepare("UPDATE orders SET status=? WHERE id=?");
        $stmt->execute([$status, $order_id]);

        header("Location: orders.php?msg=updated");
        exit;
    } else {
        echo "❌ بيانات غير صحيحة";
        exit;
    }
} else {
    echo "❌ وصول غير صحيح";
    exit;
}
