<?php
require_once "../config/db.php";
require_once "../includes/auth.php";
include "partials/header.php";

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT * FROM seo_pages WHERE id=?");
$stmt->execute([$id]);
$page = $stmt->fetch();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("UPDATE seo_pages SET title=?, description=?, keywords=?, og_image=?, og_url=? WHERE id=?");
    $stmt->execute([$_POST['title'], $_POST['description'], $_POST['keywords'], $_POST['og_image'], $_POST['og_url'], $id]);
    header("Location: seo.php?updated=1");
    exit;
}
?>

<section class="card">
  <h2>تعديل SEO - <?= e($page['page']); ?></h2>
  <form method="post">
    <label>العنوان (Title):</label>
    <input type="text" name="title" value="<?= e($page['title']); ?>" style="width:100%;padding:8px;margin:6px 0;">

    <label>الوصف (Description):</label>
    <textarea name="description" rows="3" style="width:100%;padding:8px;margin:6px 0;"><?= e($page['description']); ?></textarea>

    <label>الكلمات المفتاحية (Keywords):</label>
    <input type="text" name="keywords" value="<?= e($page['keywords']); ?>" style="width:100%;padding:8px;margin:6px 0;">

    <label>صورة OG:</label>
    <input type="text" name="og_image" value="<?= e($page['og_image']); ?>" placeholder="رابط الصورة" style="width:100%;padding:8px;margin:6px 0;">

    <label>رابط OG:</label>
    <input type="text" name="og_url" value="<?= e($page['og_url']); ?>" placeholder="الرابط المخصص" style="width:100%;padding:8px;margin:6px 0;">

    <button type="submit" class="btn">حفظ</button>
  </form>
</section>

<?php include __DIR__ . "/partials/footer.php"; ?>
