<?php
require_once __DIR__ . "/../config/db.php";
include __DIR__ . "/partials/header.php";

$order_id = $_GET['id'] ?? 0;

// جلب الطلب
$stmt = db()->prepare("SELECT * FROM orders WHERE id=? LIMIT 1");
$stmt->execute([$order_id]);
$order = $stmt->fetch();

if (!$order) {
    echo "<p style='padding:30px; color:red;'>❌ الطلب غير موجود</p>";
    include __DIR__ . "/partials/footer.php";
    exit;
}

// جلب المنتجات
$stmt = db()->prepare("
  SELECT oi.*, p.name, p.image 
  FROM order_items oi
  JOIN products p ON oi.product_id = p.id
  WHERE oi.order_id=?
");
$stmt->execute([$order_id]);
$items = $stmt->fetchAll();
?>

<div class="container">
  <h2 class="admin-title">تفاصيل الطلب #<?= $order['id'] ?></h2>
  <p>الحالة: <?= $order['status'] ?> | الإجمالي: <?= number_format($order['total'], 2) ?> ر.س</p>

  <table class="table">
    <thead>
      <tr>
        <th>الصورة</th>
        <th>المنتج</th>
        <th>الكمية</th>
        <th>المجموع</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($items as $it): ?>
        <tr>
          <td><img src="../uploads/<?= htmlspecialchars($it['image']) ?>" style="max-height:60px;"></td>
          <td><?= htmlspecialchars($it['name']) ?></td>
          <td><?= $it['quantity'] ?></td>
          <td><?= number_format($it['price'], 2) ?> ر.س</td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<?php include __DIR__ . "/partials/footer.php"; ?>
