<?php
if (session_status()===PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/../config/db.php';

$id = (int)($_GET['id'] ?? 0);
$stmt = db()->prepare("SELECT * FROM blog_posts WHERE id=? LIMIT 1");
$stmt->execute([$id]);
$post = $stmt->fetch();
if (!$post) { header('Location: blog.php'); exit; }

$uploadDir = __DIR__ . '/../uploads/';
if (!is_dir($uploadDir)) @mkdir($uploadDir,0777,true);

$msg = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $title    = trim($_POST['title'] ?? '');
  $summary  = trim($_POST['summary'] ?? '');
  $details  = trim($_POST['details'] ?? '');
  $status   = isset($_POST['status']) ? 1 : 0;

  $image = $post['image'];
  if (!empty($_FILES['image']['name']) && is_uploaded_file($_FILES['image']['tmp_name'])) {
    $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));
    if (!in_array($ext,['jpg','jpeg','png','webp'])) $msg = 'صيغة الصورة غير مسموحة.';
    else {
      $new = 'blog_'.date('Ymd_His').'_'.bin2hex(random_bytes(3)).'.'.$ext;
      if (move_uploaded_file($_FILES['image']['tmp_name'], $uploadDir.$new)) {
        if (!empty($image) && is_file($uploadDir.$image)) @unlink($uploadDir.$image);
        $image = $new;
      }
    }
  }

  if (!$msg) {
    $q = "UPDATE blog_posts SET title=?, summary=?, details=?, image=?, status=? WHERE id=?";
    db()->prepare($q)->execute([$title,$summary,$details,$image,$status,$id]);
    header('Location: blog.php'); exit;
  }
}
?>
<!doctype html><html lang="ar" dir="rtl"><head>
<meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>تعديل مقال</title>
<style>
body{background:#0a0a0a;color:#e0e0e0;font-family:'Cairo','Segoe UI',Tahoma,sans-serif;margin:0;padding:24px}
.wrap{max-width:900px;margin:0 auto}
.card{background:#111;border:1px solid #2a2a2a;border-radius:12px;padding:16px}
h1{margin-top:0}
label{display:block;margin:10px 0 6px}
input[type=text],textarea{width:100%;background:#0b0b0b;border:1px solid #2a2a2a;border-radius:10px;padding:10px;color:#e0e0e0}
textarea{min-height:130px}
.btn{background:#D4AF37;color:#000;border:0;border-radius:10px;padding:10px 14px;font-weight:700;cursor:pointer;margin-top:10px}
.note{color:#aaa;font-size:13px}
.err{background:#3f1d1d;border:1px solid #7f1d1d;color:#fee2e2;padding:8px 10px;border-radius:10px;margin-bottom:10px}
.thumb{width:100%;height:200px;background:#222;border-radius:10px;overflow:hidden;margin-bottom:8px}
.thumb img{width:100%;height:100%;object-fit:cover}
</style>
</head><body>
<div class="wrap">
  <h1>تعديل مقال</h1>
  <?php if ($msg): ?><div class="err"><?= htmlspecialchars($msg) ?></div><?php endif; ?>
  <form class="card" method="post" enctype="multipart/form-data">
    <label>العنوان *</label>
    <input type="text" name="title" required value="<?= htmlspecialchars($post['title']) ?>">

    <label>النبذة</label>
    <textarea name="summary"><?= htmlspecialchars($post['summary']) ?></textarea>

    <label>التفاصيل</label>
    <textarea name="details"><?= htmlspecialchars($post['details']) ?></textarea>

    <label>الصورة (اتركها فارغة للإبقاء على الحالية)</label>
    <div class="thumb"><?php if($post['image']): ?><img src="../<?= (strpos($post['image'],'/')===false?'uploads/':'').htmlspecialchars($post['image']) ?>"><?php endif; ?></div>
    <input type="file" name="image" accept=".jpg,.jpeg,.png,.webp">

    <label><input type="checkbox" name="status" <?= $post['status']?'checked':'' ?>> منشور</label>

    <button class="btn" type="submit">حفظ</button>
    <a class="btn" style="background:#1f2937;color:#fff" href="blog.php">عودة</a>
  </form>
</div>
</body></html>
