<?php
require_once "../config/db.php";
require_once "../includes/auth.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = $_POST['title'] ?? '';
    $content = $_POST['content'] ?? '';
    $icon = $_POST['icon'] ?? 'fas fa-gem';
    $sort = intval($_POST['sort_order'] ?? 0);

    $stmt = db()->prepare("INSERT INTO about_sections (title, content, icon, sort_order) VALUES (?, ?, ?, ?)");
    $stmt->execute([$title, $content, $icon, $sort]);

    header("Location: about.php");
    exit;
}

include "partials/header.php";
?>

<div class="admin-content">
  <h2>➕ إضافة قسم جديد</h2>
  <form method="post">
    <label>العنوان:</label>
    <input type="text" name="title" required>

    <label>المحتوى:</label>
    <textarea name="content" rows="5" required></textarea>

    <label>الأيقونة (FontAwesome):</label>
    <input type="text" name="icon" value="fas fa-gem">

    <label>الترتيب:</label>
    <input type="number" name="sort_order" value="0">

    <button type="submit" class="btn">حفظ</button>
  </form>
</div>

<?php include "partials/footer.php"; ?>
