<?php
// about.php (Dynamic)
require_once __DIR__ . "/config/db.php";
include __DIR__ . "/includes/header.php";

/* ==== جلب البيانات من الجداول ==== */
$hero = db()->query("SELECT * FROM about_hero WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$intro = db()->query("SELECT * FROM about_intro WHERE id=1")->fetch(PDO::FETCH_ASSOC);
$rmv = db()->query("SELECT * FROM about_rmv WHERE status=1 ORDER BY sort, id")->fetchAll(PDO::FETCH_ASSOC);
$counters = db()->query("SELECT * FROM about_counters WHERE status=1 ORDER BY sort, id")->fetchAll(PDO::FETCH_ASSOC);
$timeline = db()->query("SELECT * FROM about_timeline WHERE status=1 ORDER BY sort, id")->fetchAll(PDO::FETCH_ASSOC);
$team = db()->query("SELECT * FROM about_team WHERE status=1 ORDER BY sort, id")->fetchAll(PDO::FETCH_ASSOC);
$faqs = db()->query("SELECT * FROM about_faq WHERE status=1 ORDER BY sort, id")->fetchAll(PDO::FETCH_ASSOC);
$cta = db()->query("SELECT * FROM about_cta WHERE id=1")->fetch(PDO::FETCH_ASSOC);

/* ==== دوال مساعدة ==== */
function file_or_fallback($path, $fallback){
  if(!$path) return $fallback;
  if (preg_match('~^https?://|^data:~i', $path)) return $path;
  $rel = ltrim($path, '/');
  return is_file(__DIR__ . "/$rel") ? $path : $fallback;
}
$heroBg = file_or_fallback($hero['bg_image'] ?? '', 'assets/img/about-hero.jpg');
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>عن الكندي | الكندي للذهب والمجوهرات</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- أيقونات -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
/* ===== Cairo + القيم الأساسية ===== */
@import url('https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700;800&display=swap');
:root{
  --primary-color:#D4AF37; /* ذهب */
  --text-color:#e0e0e0;
  --dark:#0b0b0b; --card:#121212; --muted:#9aa7b1; --line:#232323;
  --gold-1:#7a5c1e; --gold-2:#b68f2a; --gold-3:#d4af37; --gold-4:#c8a951;
}
html,body,button,input,select,textarea{font-family:'Cairo','Segoe UI',Tahoma,Geneva,Verdana,sans-serif!important}
body{background:#0a0a0a;color:var(--text-color);}

/* ===== هيدر داخلي (Hero) ===== */
.inner-hero{position:relative;overflow:hidden;height:360px;background:#000;margin-top:0}
.inner-hero::before{content:"";position:absolute;inset:0;background:url('<?= htmlspecialchars($heroBg) ?>') center/cover no-repeat;filter:saturate(1.05) contrast(1.05) brightness(.85)}
.inner-hero::after{content:"";position:absolute;inset:0;background:radial-gradient(60% 80% at 50% 50%, rgba(0,0,0,.45), rgba(0,0,0,.75))}
.inner-hero .content{position:relative;z-index:2;height:100%;display:flex;flex-direction:column;align-items:center;justify-content:center;text-align:center;padding:0 20px}
.breadcrumbs{display:inline-flex;gap:10px;align-items:center;color:#dedede;font-size:13px;opacity:.9}
.breadcrumbs a{color:#fff;text-decoration:none}
.inner-hero h1{margin:10px 0 8px;font-size:40px;font-weight:900;background:linear-gradient(90deg,var(--gold-2),var(--gold-3),var(--gold-4));-webkit-background-clip:text;background-clip:text;color:transparent;text-shadow:0 2px 8px rgba(0,0,0,.35)}
.inner-hero p{margin:0;color:#eee;max-width:860px;line-height:1.9}

/* ===== حاوية الأقسام ===== */
.section{width:90%;margin:0 auto;padding:54px 0}
.section-title{margin:0 0 16px;text-align:center;font-size:28px;position:relative;font-weight:800;letter-spacing:.2px}
.section-title::after{content:"";display:block;width:70px;height:3px;background:var(--primary-color);margin:10px auto;border-radius:8px}
.section-sub{color:var(--muted);text-align:center;margin:0 auto 26px;max-width:800px}

/* ===== بطاقة عامة ===== */
.card{background:linear-gradient(180deg,#121212 0%,#0f0f0f 100%);border:1px solid rgba(212,175,55,.45);border-radius:16px;padding:20px;box-shadow:0 14px 30px rgba(0,0,0,.35)}

/* ===== من نحن (بطاقة متمركزة) ===== */
.about-block{width:min(1100px,95%);margin:0 auto}
.about-card{position:relative;isolation:isolate;overflow:hidden;display:grid;grid-template-columns:84px 1fr;gap:18px;padding:26px 26px}
.about-card::before{content:"";position:absolute;inset:-1px;border-radius:18px;pointer-events:none;background:conic-gradient(from 180deg,var(--gold-1),var(--gold-2),var(--gold-3),var(--gold-4),var(--gold-2),var(--gold-1));filter:blur(10px) saturate(1.2);opacity:.2;animation:spin 7s linear infinite}
@keyframes spin{to{transform:rotate(360deg)}}
.about-icon{align-self:start;width:84px;height:84px;border-radius:50%;display:grid;place-items:center;font-size:30px;color:#0f0f0f;background:linear-gradient(145deg,var(--gold-2),var(--gold-3),var(--gold-4));box-shadow:inset 0 2px 8px rgba(255,255,255,.25),0 10px 26px rgba(0,0,0,.35)}
.about-text{color:#cbd5e1;line-height:1.95;font-size:16px}
.about-cta{margin-top:12px;display:inline-flex;align-items:center;gap:8px;padding:10px 16px;border-radius:10px;color:#0f0f0f;text-decoration:none!important;font-weight:800;background:linear-gradient(145deg,var(--gold-2),var(--gold-3),var(--gold-4));box-shadow:0 12px 28px rgba(212,175,55,.25),inset 0 1px 0 rgba(255,255,255,.25);transition:transform .2s,filter .2s,box-shadow .2s}
.about-cta:hover{transform:translateY(-2px);filter:saturate(1.05);box-shadow:0 16px 36px rgba(212,175,55,.3)}

/* ===== رؤية / رسالة / قيم ===== */
.rmv-grid{display:grid;grid-template-columns:repeat(3,1fr);gap:18px}
@media (max-width:992px){.rmv-grid{grid-template-columns:1fr 1fr}}
@media (max-width:640px){.rmv-grid{grid-template-columns:1fr}}
.rmv .head{display:flex;align-items:center;justify-content:space-between;gap:14px;margin-bottom:10px}
.rmv .ico{width:56px;height:56px;border-radius:50%;display:grid;place-items:center;color:#0f0f0f;font-size:20px;background:linear-gradient(145deg,var(--gold-2),var(--gold-3),var(--gold-4));box-shadow:inset 0 2px 8px rgba(255,255,255,.25)}
.rmv h3{margin:0;font-size:20px;background:linear-gradient(90deg,var(--gold-2),var(--gold-3));-webkit-background-clip:text;background-clip:text;color:transparent}
.rmv p{margin:0;color:#cbd5e1;line-height:1.9}
.values{display:flex;flex-wrap:wrap;gap:10px;margin-top:10px}
.values .chip{padding:8px 12px;border-radius:999px;font-size:13px;font-weight:700;color:#0f0f0f;background:linear-gradient(145deg,var(--gold-2),var(--gold-3));box-shadow:inset 0 1px 0 rgba(255,255,255,.25)}

/* ===== الأرقام ===== */
.counters{display:grid;grid-template-columns:repeat(4,1fr);gap:14px}
@media (max-width:992px){.counters{grid-template-columns:repeat(2,1fr)}}
@media (max-width:520px){.counters{grid-template-columns:1fr}}
.counter{text-align:center;padding:24px 16px;background:linear-gradient(180deg,#121212 0%,#0f0f0f 100%);border:1px solid rgba(212,175,55,.35);border-radius:14px;box-shadow:0 12px 26px rgba(0,0,0,.35)}
.counter .num{font-size:34px;font-weight:900;line-height:1;background:linear-gradient(90deg,var(--gold-2),var(--gold-3),var(--gold-4));-webkit-background-clip:text;background-clip:text;color:transparent}
.counter .lbl{color:var(--muted);margin-top:6px}

/* ===== المسار الزمني ===== */
.timeline{position:relative;padding-right:26px}
.timeline::before{content:"";position:absolute;right:10px;top:0;bottom:0;width:2px;background:linear-gradient(180deg, rgba(212,175,55,.0), rgba(212,175,55,.6), rgba(212,175,55,.0))}
.ti{position:relative;margin:16px 0;padding:16px 16px 16px 14px;border-radius:14px;background:linear-gradient(180deg,#121212 0%,#0f0f0f 100%);border:1px solid rgba(212,175,55,.25);box-shadow:0 10px 22px rgba(0,0,0,.35)}
.ti::before{content:"";position:absolute;right:3px;top:20px;width:12px;height:12px;border-radius:50%;background:linear-gradient(145deg,var(--gold-2),var(--gold-3));box-shadow:0 0 0 4px rgba(212,175,55,.18)}
.ti h4{margin:0 0 6px;font-size:18px;color:#fff}
.ti p{margin:0;color:#cbd5e1;line-height:1.85;font-size:15px}

/* ===== الفريق ===== */
.team-grid{display:grid;grid-template-columns:repeat(4,1fr);gap:16px}
@media (max-width:992px){.team-grid{grid-template-columns:repeat(2,1fr)}}
@media (max-width:520px){.team-grid{grid-template-columns:1fr}}
.member{overflow:hidden;border-radius:14px;position:relative;background:#111;border:1px solid rgba(212,175,55,.2);transition:transform .3s,box-shadow .3s,border-color .3s}
.member:hover{transform:translateY(-6px);box-shadow:0 18px 36px rgba(0,0,0,.45);border-color:rgba(212,175,55,.4)}
.member .ph{height:220px;background:#1b1b1b;overflow:hidden}
.member .ph img{width:100%;height:100%;object-fit:cover;transition:transform .6s,filter .6s}
.member:hover .ph img{transform:scale(1.06);filter:saturate(1.06)}
.member .info{padding:12px 14px}
.member .name{margin:0;font-weight:800}
.member .role{margin:2px 0 0;color:var(--muted);font-size:13px}

/* ===== أسئلة شائعة ===== */
.faq{max-width:1000px;margin:0 auto}
.acc{border-radius:14px;overflow:hidden;border:1px solid rgba(212,175,55,.35)}
.acc-item{border-bottom:1px solid #1a1a1a;background:linear-gradient(180deg,#121212 0%,#0f0f0f 100%)}
.acc-h{padding:14px 16px;display:flex;align-items:center;justify-content:space-between;gap:10px;cursor:pointer}
.acc-h h3{margin:0;font-size:16px}
.acc-c{max-height:0;overflow:hidden;transition:max-height .35s ease}
.acc-c .pad{padding:0 16px 16px;color:#cbd5e1;line-height:1.9}
.acc-item.active .acc-c{max-height:240px}
.acc-item.active .acc-h i{transform:rotate(180deg)}

/* ===== CTA ===== */
.cta{text-align:center;padding:26px;border-radius:18px;background:radial-gradient(100% 120% at 90% -20%, rgba(212,175,55,.18), transparent 40%),linear-gradient(180deg,#121212 0%,#0f0f0f 100%);border:1px solid rgba(212,175,55,.45);box-shadow:0 14px 30px rgba(0,0,0,.35)}
.btn-gold{display:inline-flex;align-items:center;gap:8px;padding:12px 18px;border-radius:12px;font-weight:800;color:#0f0f0f;background:linear-gradient(145deg,var(--gold-2),var(--gold-3),var(--gold-4));box-shadow:0 12px 28px rgba(212,175,55,.25),inset 0 1px 0 rgba(255,255,255,.25);text-decoration:none!important;transition:transform .2s,filter .2s,box-shadow .2s}
.btn-gold:hover{transform:translateY(-2px);filter:saturate(1.05);box-shadow:0 16px 36px rgba(212,175,55,.32)}

/* ===== Reveal ===== */
.reveal{opacity:0;transform:translateY(18px) scale(.98);transition:opacity .6s ease,transform .6s ease}
.reveal.visible{opacity:1;transform:translateY(0) scale(1)}
</style>
</head>
<body>

<!-- HERO -->
<section class="inner-hero">
  <div class="content">
    <nav class="breadcrumbs">
      <a href="index.php"><i class="fa-solid fa-house-chimney"></i> الرئيسية</a>
      <span><i class="fa-solid fa-angles-left"></i></span>
      <span>عنّا</span>
    </nav>
    <h1><?= htmlspecialchars($hero['title'] ?? 'عن الكندي للذهب والمجوهرات') ?></h1>
    <?php if(!empty($hero['subtitle'])): ?>
      <p><?= htmlspecialchars($hero['subtitle']) ?></p>
    <?php endif; ?>
  </div>
</section>

<!-- من نحن -->
<section class="section about-block">
  <div class="card about-card reveal">
    <div class="about-icon"><i class="fa-solid fa-gem"></i></div>
    <div>
      <p class="about-text">
        <?= nl2br(htmlspecialchars($intro['body'] ?? '')) ?>
      </p>
      <a class="about-cta" href="contact.php"><i class="fa-solid fa-handshake"></i> تواصل معنا</a>
    </div>
  </div>
</section>

<!-- رؤية/رسالة/قيم -->
<section class="section">
  <h2 class="section-title">رؤيتنا ورسالتنا وقيمنا</h2>
  <p class="section-sub">نطمح لأن نكون الوجهة الأولى لعشّاق الذهب والمستثمرين، عبر منتجات أصلية وخدمات موثوقة وتجربة تسوّق راقية.</p>
  <div class="rmv-grid">
    <?php
      // ترتيب العناصر حسب النوع لضمان ظهور Vision/Mission/Values بشكل منسق
      $order = ['vision'=>[], 'mission'=>[], 'values'=>[]];
      foreach($rmv as $row){ $order[$row['kind']][] = $row; }
      $mapTitle = ['vision'=>'الرؤية', 'mission'=>'الرسالة', 'values'=>'القيم'];
      $mapIcon  = ['vision'=>'fa-eye', 'mission'=>'fa-bullseye', 'values'=>'fa-heart'];
      foreach (['vision','mission','values'] as $kind):
        foreach($order[$kind] as $item):
    ?>
      <div class="card rmv reveal">
        <div class="head">
          <h3><?= htmlspecialchars($item['title'] ?: $mapTitle[$kind]) ?></h3>
          <span class="ico"><i class="fa-solid <?= $mapIcon[$kind] ?>"></i></span>
        </div>
        <?php if(!empty($item['description'])): ?>
          <p><?= nl2br(htmlspecialchars($item['description'])) ?></p>
        <?php endif; ?>
        <?php if($kind==='values' && !empty($item['chips'])): ?>
          <div class="values">
            <?php foreach(array_filter(array_map('trim', explode("\n", $item['chips']))) as $chip): ?>
              <span class="chip"><?= htmlspecialchars($chip) ?></span>
            <?php endforeach; ?>
          </div>
        <?php endif; ?>
      </div>
    <?php endforeach; endforeach; ?>
    <?php if(!$rmv): ?>
      <div style="grid-column:1/-1;color:#aaa;text-align:center">لا توجد بيانات بعد.</div>
    <?php endif; ?>
  </div>
</section>

<!-- الأرقام -->
<section class="section">
  <div class="counters">
    <?php foreach($counters as $c): ?>
      <div class="counter reveal">
        <div class="num" data-count="<?= (int)$c['number'] ?>">0</div>
        <div class="lbl"><?= htmlspecialchars($c['label']) ?></div>
      </div>
    <?php endforeach; ?>
    <?php if(!$counters): ?>
      <div style="grid-column:1/-1;color:#aaa;text-align:center">لا توجد أرقام معروضة.</div>
    <?php endif; ?>
  </div>
</section>

<!-- المسار الزمني -->
<section class="section">
  <h2 class="section-title">محطات من رحلتنا</h2>
  <div class="timeline">
    <?php foreach($timeline as $t): ?>
      <div class="ti reveal">
        <h4><?= htmlspecialchars($t['title']) ?></h4>
        <?php if(!empty($t['description'])): ?>
          <p><?= nl2br(htmlspecialchars($t['description'])) ?></p>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
    <?php if(!$timeline): ?>
      <div style="color:#aaa;text-align:center">لا توجد محطات زمنية.</div>
    <?php endif; ?>
  </div>
</section>

<!-- الفريق -->
<section class="section">
  <h2 class="section-title">فريق يقود الشغف بالجودة</h2>
  <p class="section-sub">فريقنا يضم خبراء معتمدين في تقييم الذهب وخدمة العملاء وإدارة سلسلة الإمداد.</p>
  <div class="team-grid">
    <?php foreach($team as $m): 
      $photo = file_or_fallback($m['photo'] ?? '', 'assets/img/team-placeholder.jpg'); ?>
      <div class="member reveal">
        <div class="ph"><img src="<?= htmlspecialchars($photo) ?>" alt=""></div>
        <div class="info">
          <h4 class="name"><?= htmlspecialchars($m['name']) ?></h4>
          <?php if(!empty($m['role'])): ?><div class="role"><?= htmlspecialchars($m['role']) ?></div><?php endif; ?>
        </div>
      </div>
    <?php endforeach; ?>
    <?php if(!$team): ?>
      <div style="grid-column:1/-1;color:#aaa;text-align:center">لم يتم إضافة أعضاء فريق بعد.</div>
    <?php endif; ?>
  </div>
</section>

<!-- أسئلة شائعة -->
<section class="section">
  <h2 class="section-title">أسئلة شائعة</h2>
  <div class="faq acc reveal">
    <?php foreach($faqs as $q): ?>
      <div class="acc-item">
        <div class="acc-h">
          <h3><?= htmlspecialchars($q['question']) ?></h3>
          <i class="fa-solid fa-chevron-down"></i>
        </div>
        <div class="acc-c"><div class="pad"><?= nl2br(htmlspecialchars($q['answer'])) ?></div></div>
      </div>
    <?php endforeach; ?>
    <?php if(!$faqs): ?>
      <div style="text-align:center;color:#aaa;padding:14px">لا توجد أسئلة حتى الآن.</div>
    <?php endif; ?>
  </div>
</section>

<!-- CTA -->
<section class="section">
  <div class="cta reveal">
    <h3 style="margin:0 0 8px;font-weight:900">
      <?= htmlspecialchars($cta['title'] ?? 'جاهز للاستثمار بثقة؟') ?>
    </h3>
    <?php if(!empty($cta['subtitle'])): ?>
      <p style="margin:0 0 14px;color:var(--muted)"><?= htmlspecialchars($cta['subtitle']) ?></p>
    <?php endif; ?>
    <?php if(!empty($cta['btn_text'])): ?>
      <a class="btn-gold" href="<?= htmlspecialchars($cta['btn_link'] ?: 'gold.php') ?>">
        <i class="fa-solid fa-layer-group"></i> <?= htmlspecialchars($cta['btn_text']) ?>
      </a>
    <?php endif; ?>
  </div>
</section>

<script>
/* ظهور أنيق عند التمرير */
(function(){
  const els=[...document.querySelectorAll('.reveal')];
  if(!('IntersectionObserver' in window)){ els.forEach(e=>e.classList.add('visible')); return; }
  const io=new IntersectionObserver((ents)=>{
    ents.forEach(en=>{
      if(en.isIntersecting){ en.target.classList.add('visible'); io.unobserve(en.target); }
    });
  },{threshold:.18});
  els.forEach(e=>io.observe(e));
})();

/* عدادات الأرقام */
(function(){
  const items=[...document.querySelectorAll('.num[data-count]')];
  if(!items.length) return;
  const ease=t=>1- Math.pow(1-t,3);
  function run(el){
    const target=+el.dataset.count || 0;
    const dur=1200 + (target>10000?600:0);
    let t0=null;
    function step(ts){
      if(!t0) t0=ts;
      const p=Math.min(1,(ts-t0)/dur), val=Math.floor(target*ease(p));
      el.textContent=val.toLocaleString('ar-EG');
      if(p<1) requestAnimationFrame(step);
      else el.textContent=target.toLocaleString('ar-EG');
    }
    requestAnimationFrame(step);
  }
  const io=new IntersectionObserver((ents)=>{
    ents.forEach(en=>{
      if(en.isIntersecting){ run(en.target); io.unobserve(en.target); }
    });
  },{threshold:.35});
  items.forEach(el=>io.observe(el));
})();

/* أكورديون الأسئلة الشائعة */
(function(){
  document.querySelectorAll('.acc .acc-item .acc-h').forEach(h=>{
    h.addEventListener('click',()=>{
      const it=h.parentElement;
      const list=[...it.parentElement.children];
      list.forEach(x=>{ if(x!==it && x.classList) x.classList.remove('active');});
      it.classList.toggle('active');
    });
  });
})();
</script>

<?php include __DIR__ . "/includes/footer.php"; ?>
</body>
</html>
