<?php
include "../includes/header.php"; 
require_once "../includes/db.php";

// نفترض أن المستخدم مسجل دخوله
// (يمكنك تعديل الكود لاحقًا ليتوافق مع نظام تسجيل الدخول)
$user_id = $_SESSION['user_id'] ?? 1;

// إحصائيات المستخدم
$totalOrders   = $pdo->query("SELECT COUNT(*) FROM orders WHERE user_id=$user_id")->fetchColumn();
$confirmed     = $pdo->query("SELECT COUNT(*) FROM orders WHERE user_id=$user_id AND status='مؤكد'")->fetchColumn();
$pending       = $pdo->query("SELECT COUNT(*) FROM orders WHERE user_id=$user_id AND status='بانتظار'")->fetchColumn();
$rejected      = $pdo->query("SELECT COUNT(*) FROM orders WHERE user_id=$user_id AND status='مرفوض'")->fetchColumn();

// آخر 5 طلبات
$stmt = $pdo->prepare("SELECT o.*, b.bank_name 
                       FROM orders o 
                       LEFT JOIN bank_accounts b ON o.bank_account_id=b.id 
                       WHERE o.user_id=? 
                       ORDER BY o.id DESC 
                       LIMIT 5");
$stmt->execute([$user_id]);
$orders = $stmt->fetchAll();
?>

<section class="container" style="margin-top:40px;">
  <h2 class="section-title">لوحة التحكم الخاصة بي</h2>

  <div style="display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:20px;margin-top:20px;">
    <div class="card"><h3>كل الطلبات</h3><p style="font-size:22px;color:#D4AF37;"><?= $totalOrders; ?></p></div>
    <div class="card"><h3>مؤكد</h3><p style="font-size:22px;color:#2e7d32;"><?= $confirmed; ?></p></div>
    <div class="card"><h3>بانتظار</h3><p style="font-size:22px;color:#fbc02d;"><?= $pending; ?></p></div>
    <div class="card"><h3>مرفوض</h3><p style="font-size:22px;color:#c62828;"><?= $rejected; ?></p></div>
  </div>
</section>

<section class="container" style="margin-top:40px;">
  <h2 class="section-title">آخر طلباتي</h2>
  <table style="width:100%; background:#121212; color:#fff; border-collapse: collapse;">
    <tr>
      <th>البنك</th>
      <th>المبلغ</th>
      <th>الحالة</th>
      <th>الإيصال</th>
      <th>التاريخ</th>
    </tr>
    <?php foreach($orders as $o): ?>
    <tr>
      <td><?= e($o['bank_name']); ?></td>
      <td><?= formatPrice($o['amount']); ?></td>
      <td><span class="status <?= e($o['status']); ?>"><?= e($o['status']); ?></span></td>
      <td>
        <?php if ($o['slip']): ?>
          <a href="../assets/uploads/<?= e($o['slip']); ?>" target="_blank">عرض</a>
        <?php endif; ?>
      </td>
      <td><?= date("Y-m-d", strtotime($o['created_at'])); ?></td>
    </tr>
    <?php endforeach; ?>
  </table>
</section>

<?php include "../includes/footer.php"; ?>
