<?php
// product.php — مع الكمية + أزرار السلة والشراء (إصلاح headers already sent)
if (session_status() === PHP_SESSION_NONE) session_start();

require_once __DIR__ . "/config/db.php";
require_once __DIR__ . "/config/price.php";

$pdo = db();

// ----- جلب المنتج -----
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$stmt = $pdo->prepare("SELECT * FROM products WHERE id=? AND status=1 LIMIT 1");
$stmt->execute([$id]);
$product = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$product) {
  // منتج غير موجود
  header("Location: index.php");
  exit;
}

// أسعار
$prices = getPrices(); // gold_24, gold_21, gold_18, silver

// ----- CSRF بسيط -----
if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));

// ----- معالجة POST (قبل أي إخراج) -----
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $csrf = $_POST['csrf'] ?? '';
  if (!hash_equals($_SESSION['csrf'], $csrf)) {
    // رمز غير صالح: ارجع لنفس الصفحة برسالة
    header("Location: product.php?id={$id}&err=csrf");
    exit;
  }

  $qty = max(1, min(999, (int)($_POST['qty'] ?? 1)));

  // هيكل السلة: [product_id => quantity]
  if (!isset($_SESSION['cart']) || !is_array($_SESSION['cart'])) $_SESSION['cart'] = [];
  if (!isset($_SESSION['cart'][$id])) $_SESSION['cart'][$id] = 0;
  // إذا كان الشكل القديم [id => ['qty'=>..]]
  if (is_array($_SESSION['cart'][$id])) {
    $_SESSION['cart'][$id] = (int)($_SESSION['cart'][$id]['qty'] ?? 0);
  }
  $_SESSION['cart'][$id] += $qty;

  // شراء الآن = اذهب مباشرة للسلة، غير ذلك ابقَ في الصفحة برسالة نجاح
  if (isset($_POST['buy_now'])) {
    header("Location: cart.php");
  } else {
    header("Location: product.php?id={$id}&added=1");
  }
  exit;
}

// ----- بعد المعالجة: احسب السعر واعرض الصفحة -----
$isGold = (($product['metal'] ?? 'gold') === 'gold');
$key    = $isGold ? ("gold_".(int)$product['karat']) : "silver";
$unit   = (isset($prices[$key]) && is_numeric($prices[$key])) ? (float)$prices[$key] : 0.0; // ر.س/جم
$weight = (float)($product['weight'] ?? 0.0);

// مساعد الصورة
function img_or_placeholder($path) {
  if (!$path) return "assets/img/placeholder-hero.jpg";
  $rel = (strpos($path, 'uploads/') === 0) ? $path : "uploads/products/".ltrim($path,'/');
  return is_file(__DIR__ . "/".$rel) ? $rel : "assets/img/placeholder-hero.jpg";
}
function e($v){ return htmlspecialchars((string)$v, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }

include __DIR__ . "/includes/header.php";
?>
<style>
.product-view{width:min(1100px,94%);margin:28px auto;padding:0 8px}
.bread{color:#9aa7b1;margin:8px 0 18px}.bread a{color:var(--primary-color);text-decoration:none}
.pv-grid{display:grid;grid-template-columns:420px 1fr;gap:24px}
@media(max-width:900px){.pv-grid{grid-template-columns:1fr}}
.pv-card{background:linear-gradient(180deg,#141414 0%,#0f0f0f 100%);border:1px solid rgba(212,175,55,.35);border-radius:16px;box-shadow:0 14px 30px rgba(0,0,0,.35);overflow:hidden}
.pv-img{aspect-ratio:1/1;background:#111;display:grid;place-items:center}
.pv-img img{max-width:100%;max-height:100%;object-fit:contain}
.pv-body{padding:18px}
.pv-title{margin:0 0 8px;font-size:26px;color:#eee}
.pv-sub{color:#cbd5e1;margin:0 0 12px}
.price-line{display:flex;gap:12px;flex-wrap:wrap;margin:12px 0;color:#eaeaea}
.price-chip{background:linear-gradient(145deg,#b68f2a,#d4af37,#c8a951);color:#0f0f0f;border-radius:999px;padding:8px 12px;font-weight:800}
.pv-desc{color:#9aa7b1;line-height:1.9}
.pv-actions{display:flex;gap:10px;margin-top:16px;flex-wrap:wrap;align-items:center}
.btn-gold{display:inline-flex;align-items:center;gap:8px;padding:12px 16px;border-radius:12px;font-weight:800;color:#0f0f0f;text-decoration:none;background:linear-gradient(145deg,#b68f2a,#d4af37,#c8a951)}
.btn-solid{display:inline-flex;align-items:center;gap:8px;padding:12px 16px;border-radius:12px;font-weight:800;border:0;cursor:pointer}
.btn-add{background:linear-gradient(145deg,#b68f2a,#d4af37,#c8a951);color:#0f0f0f;box-shadow:0 12px 28px rgba(212,175,55,.25)}
.btn-buy{background:#16a34a;color:#0b1d10;box-shadow:0 12px 28px rgba(22,163,74,.25)}
.qty-wrap{display:flex;align-items:center;gap:10px}
.qty{display:inline-flex;align-items:center;border:1px solid rgba(212,175,55,.35);border-radius:12px;overflow:hidden}
.qty button{width:40px;height:44px;background:#0b0b0b;color:#d4af37;border:0;font-size:18px;cursor:pointer}
.qty input{width:64px;height:44px;background:#0b0b0b;color:#eaeaea;border:0;text-align:center;font-weight:800}
.alert{border-radius:10px;padding:10px 12px;margin:12px 0;font-weight:700}
.alert-ok{background:#112d1a;border:1px solid #1f7a33;color:#b8f7c8}
.alert-err{background:#3f1d1d;border:1px solid #7f1d1d;color:#fee2e2}
.related{margin:34px 0 8px}
.grid{display:grid;grid-template-columns:repeat(4,1fr);gap:18px}
@media(max-width:992px){.grid{grid-template-columns:repeat(2,1fr)}}
@media(max-width:576px){.grid{grid-template-columns:1fr}}
.card{background:linear-gradient(180deg,#141414 0%,#0f0f0f 100%);border:1px solid rgba(212,175,55,.25);border-radius:12px;overflow:hidden}
.card .th{height:180px;background:#111;display:grid;place-items:center}
.card .th img{max-width:100%;max-height:100%;object-fit:contain}
.card .bd{padding:12px}
.card h4{margin:0 0 6px;color:#eee;font-size:16px}
.card p{margin:0;color:#9aa7b1;font-size:13px}
.sub-note{font-size:.9rem;color:#9aa7b1}
</style>

<div class="product-view" dir="rtl">
  <div class="bread">
    <a href="index.php">الرئيسية</a> /
    <?php if($isGold): ?><a href="gold.php">سبائك ذهب</a><?php else: ?><a href="silver.php">سبائك فضة</a><?php endif; ?>
    / المنتج
  </div>

  <?php if(isset($_GET['added'])): ?>
    <div class="alert alert-ok"><i class="fas fa-check-circle"></i> تمت إضافة المنتج إلى السلة.</div>
  <?php endif; ?>
  <?php if(isset($_GET['err']) && $_GET['err']==='csrf'): ?>
    <div class="alert alert-err">رمز التأكيد غير صالح. أعد المحاولة.</div>
  <?php endif; ?>

  <div class="pv-grid">
    <div class="pv-card">
      <div class="pv-img">
        <img src="<?= e(img_or_placeholder($product['image'] ?? '')) ?>" alt="<?= e($product['name'] ?? '') ?>">
      </div>
    </div>
    <div class="pv-card">
      <div class="pv-body">
        <h1 class="pv-title"><?= e($product['name'] ?? '') ?></h1>
        <div class="pv-sub">
          <?= $isGold ? ("عيار ".(int)$product['karat']) : "فضة" ?> — وزن <?= number_format($weight,2) ?> جم
        </div>

        <div class="price-line">
          <span class="price-chip">سعر الوحدة: <?= number_format($unit,2) ?> ر.س/جم</span>
          <span class="price-chip">سعر القطعة: <?= number_format($unit*$weight,2) ?> ر.س</span>
        </div>

        <?php if(!empty($product['description'])): ?>
          <p class="pv-desc"><?= nl2br(e($product['description'])) ?></p>
        <?php endif; ?>

        <!-- نموذج السلة -->
        <form method="post" class="pv-actions" id="cartForm">
          <input type="hidden" name="csrf" value="<?= e($_SESSION['csrf']) ?>">
          <div class="qty-wrap">
            <label for="qty" class="sub-note">الكمية</label>
            <div class="qty">
              <button type="button" id="decQty" aria-label="إنقاص">−</button>
              <input type="number" name="qty" id="qty" value="1" min="1" max="999" inputmode="numeric">
              <button type="button" id="incQty" aria-label="زيادة">+</button>
            </div>
          </div>

          <button class="btn-solid btn-add" type="submit" name="add_to_cart">
            <i class="fas fa-cart-plus"></i> أضف للسلة
          </button>

          <button class="btn-solid btn-buy" type="submit" name="buy_now">
            <i class="fas fa-bolt"></i> شراء الآن
          </button>

          <a class="btn-gold" href="<?= $isGold ? 'gold.php' : 'silver.php' ?>">
            <i class="fas fa-arrow-right"></i> الرجوع للمنتجات
          </a>
        </form>

        <div class="sub-note" style="margin-top:6px">
          * السعر النهائي في السلة = سعر القطعة × الكمية.
        </div>
      </div>
    </div>
  </div>

  <?php
  // منتجات ذات صلة
  $rel = $pdo->prepare("SELECT id,name,image,weight,karat,metal FROM products
    WHERE status=1 AND id<>? AND metal=? ORDER BY id DESC LIMIT 4");
  $rel->execute([$product['id'], $product['metal']]);
  $related = $rel->fetchAll(PDO::FETCH_ASSOC);
  ?>
  <?php if($related): ?>
    <h3 class="related" style="color:#eee;font-weight:900">منتجات ذات صلة</h3>
    <div class="grid">
      <?php foreach($related as $r):
        $rk   = ($r['metal']==='gold') ? "gold_".$r['karat'] : "silver";
        $u    = (isset($prices[$rk]) && is_numeric($prices[$rk])) ? (float)$prices[$rk] : 0.0;
        $rtot = $u * (float)$r['weight'];
      ?>
        <article class="card">
          <a href="product.php?id=<?= (int)$r['id'] ?>" class="th">
            <img src="<?= e(img_or_placeholder($r['image'] ?? '')) ?>" alt="<?= e($r['name'] ?? '') ?>">
          </a>
          <div class="bd">
            <h4><?= e($r['name'] ?? '') ?></h4>
            <p><?= number_format($rtot,2) ?> ر.س</p>
          </div>
        </article>
      <?php endforeach; ?>
    </div>
  <?php endif; ?>
</div>

<script>
(function(){
  var q = document.getElementById('qty'),
      dec = document.getElementById('decQty'),
      inc = document.getElementById('incQty');
  if(!q) return;
  function clamp(v){ v = parseInt(v||1); if(isNaN(v)||v<1) v=1; if(v>999) v=999; return v; }
  dec && dec.addEventListener('click', function(){ q.value = clamp((q.value|0)-1); });
  inc && inc.addEventListener('click', function(){ q.value = clamp((q.value|0)+1); });
  q.addEventListener('input', function(){ q.value = clamp(q.value); });
})();
</script>

<?php include __DIR__ . "/includes/footer.php"; ?>
