<?php
session_start();
require_once __DIR__ . "/config/db.php";
include __DIR__ . "/includes/header.php";

if (!isset($_SESSION['user_id'])) {
    echo "<p style='text-align:center; padding:50px;'>⚠️ الرجاء تسجيل الدخول</p>";
    include __DIR__ . "/includes/footer.php";
    exit;
}

$order_id = $_GET['id'] ?? 0;
$user_id = $_SESSION['user_id'];

// جلب الطلب
$stmt = db()->prepare("SELECT * FROM orders WHERE id=? AND user_id=? LIMIT 1");
$stmt->execute([$order_id, $user_id]);
$order = $stmt->fetch();

if (!$order) {
    echo "<p style='text-align:center; padding:50px;'>❌ الطلب غير موجود</p>";
    include __DIR__ . "/includes/footer.php";
    exit;
}

// جلب المنتجات الخاصة بالطلب
$stmt = db()->prepare("SELECT oi.*, p.name, p.image FROM order_items oi 
                       JOIN products p ON oi.product_id = p.id 
                       WHERE oi.order_id=?");
$stmt->execute([$order_id]);
$items = $stmt->fetchAll();
?>

<section class="featured-products">
  <h2 class="section-title">تفاصيل الطلب #<?= $order['id'] ?></h2>
  <p style="text-align:center;">الحالة: <?= htmlspecialchars($order['status']) ?> | الإجمالي: <?= number_format($order['total'], 2) ?> ر.س</p>

  <div class="products-grid">
    <?php foreach ($items as $item): ?>
      <div class="product-card">
        <div class="product-image">
          <img src="uploads/<?= htmlspecialchars($item['image']) ?>" alt="<?= htmlspecialchars($item['name']) ?>">
        </div>
        <div class="product-info">
          <h3 class="product-title"><?= htmlspecialchars($item['name']) ?></h3>
          <ul class="product-features">
            <li>الكمية: <?= $item['quantity'] ?></li>
            <li>السعر: <?= number_format($item['price'], 2) ?> ر.س</li>
          </ul>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</section>

<?php include __DIR__ . "/includes/footer.php"; ?>
