<?php
require_once "config/db.php";
include "includes/header.php";

$stmt = db()->prepare("SELECT * FROM products WHERE category=? ORDER BY id DESC");
$stmt->execute(['jewelry']);
$products = $stmt->fetchAll();
?>
<section class="featured-products">
  <h2 class="section-title">المجوهرات</h2>
  <div class="products-grid">
    <?php foreach ($products as $p): ?>
    <div class="product-card">
      <div class="product-image">
        <img src="uploads/<?= htmlspecialchars($p['image']) ?>" alt="<?= htmlspecialchars($p['name']) ?>">
      </div>
      <div class="product-info">
        <h3 class="product-title"><?= htmlspecialchars($p['name']) ?></h3>
        <div class="product-price"><?= number_format($p['price']) ?> ريال</div>
        <a href="product.php?id=<?= $p['id'] ?>" class="details-btn">عرض التفاصيل</a>
      </div>
    </div>
    <?php endforeach; ?>
    <?php if (empty($products)): ?>
      <p style="text-align:center;">❌ لا توجد مجوهرات حالياً</p>
    <?php endif; ?>
  </div>
</section>
<?php include "includes/footer.php"; ?>
