<?php
// ===================== حارس منع التضمين المزدوج =====================
if (defined('ALK_HEADER_INCLUDED')) return;
define('ALK_HEADER_INCLUDED', true);

// جلسة
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// جلب الأسعار
require_once __DIR__ . "/../config/price.php";
$prices = getPrices();

// تثبيت القيم على شكل أرقام مع تنسيق بسيط
$gold24 = (isset($prices['gold_24']) && is_numeric($prices['gold_24'])) ? number_format((float)$prices['gold_24'], 2) : '—';
$gold21 = (isset($prices['gold_21']) && is_numeric($prices['gold_21'])) ? number_format((float)$prices['gold_21'], 2) : '—';
$gold18 = (isset($prices['gold_18']) && is_numeric($prices['gold_18'])) ? number_format((float)$prices['gold_18'], 2) : '—';
$silver = (isset($prices['silver'])  && is_numeric($prices['silver']))  ? number_format((float)$prices['silver'],  2) : '—';

// عدد المنتجات في السلة (يدعم شكلين: [id=>qty] أو [id=>['qty'=>..]])
$cartCount = 0;
if (!empty($_SESSION['cart']) && is_array($_SESSION['cart'])) {
  foreach ($_SESSION['cart'] as $item) {
    $cartCount += is_array($item) ? (int)($item['qty'] ?? 0) : (int)$item;
  }
}

// الصفحة الحالية لتمييز الرابط النشط
$current = basename($_SERVER['PHP_SELF']);

// دالة active مُحصّنة ضد إعادة التعريف
if (!function_exists('active')) {
    function active(string $file, string $current): string {
        return ($file === $current) ? ' class="active"' : '';
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>الكنـدي للذهب والمجوهرات</title>

  <!-- خط Cairo -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">

  <!-- التنسيقات العامة -->
  <link rel="stylesheet" href="assets/css/style.css" />

  <!-- Font Awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />

  <!-- ضبط خط Cairo كمخطط افتراضي عالمي + شارة السلة -->
<style>
  /* === خط Cairo افتراضي لكل الموقع بدون كسر الأيقونات === */
  :root{
    --font-main: 'Cairo','Segoe UI',Tahoma,Geneva,Verdana,sans-serif;
  }
  html, body, button, input, select, textarea{
    font-family: var(--font-main) !important;
  }
  /* تأكيد على مناطق الهيدر والقائمة وشريط الأسعار */
  .header, .header *, .nav-menu, .nav-menu *, .metal-prices-bar, .metal-prices-bar *{
    font-family: var(--font-main) !important;
  }

  /* === استثناء Font Awesome حتى لا تتحول الأيقونات لمربعات === */
/* لا تغيّر هذا المقطع */
.fa, .fas, .far, .fal, .fad, .fa-solid, .fa-regular{
  font-family: "Font Awesome 6 Free" !important;
}
.fas, .fa-solid{ font-weight: 900 !important; }   /* Solid */
.far, .fa-regular{ font-weight: 400 !important; } /* Regular */

.fab, .fa-brands{
  font-family: "Font Awesome 6 Brands" !important;
  font-weight: 400 !important;
}


  /* شارة السلة */
  .header .cart-btn{
    position: relative;
    display: inline-block;
    line-height: 1;
  }
  .header .cart-btn .cart-count{
    position: absolute;
    top: -6px;
    inset-inline-start: -6px; /* RTL/LTR */
    min-width: 18px;
    height: 18px;
    padding: 0 6px;
    border-radius: 999px;
    background: #e11d48;
    color: #fff;
    font-size: 11px;
    font-weight: 800;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 0 0 2px #0f0f0f;
    z-index: 2;
  }
  .header .cart-btn .cart-count.animate{ animation: alk-pop .4s ease; }
  @keyframes alk-pop{
    0%{transform:scale(.8);opacity:.7}
    60%{transform:scale(1.15);opacity:1}
    100%{transform:scale(1)}
  }
  /* أزرار تسوّق */
.btn, .btn:link, .btn:visited{
  display:inline-flex; align-items:center; gap:8px;
  padding:12px 18px; border-radius:12px; font-weight:800;
  text-decoration:none; border:0; cursor:pointer;
  font-family:'Cairo','Segoe UI',Tahoma,Geneva,Verdana,sans-serif;
}
.btn-gold{ background:linear-gradient(145deg,#b68f2a,#d4af37,#c8a951); color:#0f0f0f; box-shadow:0 10px 24px rgba(212,175,55,.25); }
.btn-silver{ background:linear-gradient(145deg,#9aa4ad,#cbd5e1,#94a3b8); color:#0b0b0b; box-shadow:0 10px 24px rgba(148,163,184,.25); }
.btn:hover{ transform:translateY(-2px); }

/* حل البنفسجي: ثبّت لون الروابط الافتراضي */
a, a:link, a:visited { color: var(--text-color, #eaeaea); text-decoration:none; }
a:hover { color: var(--primary-color, #d4af37); }
/* اجعل روابط الأزرار ترث اللون بدل البنفسجي الافتراضي */
.btn, .btn:link, .btn:visited { color: inherit; text-decoration: none; }

/* زر الذهب: نص غامق دائمًا */
.btn-gold{
  background: linear-gradient(145deg,#b68f2a,#d4af37,#c8a951);
  color: #0f0f0f !important;           /* نص غامق */
  box-shadow: 0 10px 24px rgba(212,175,55,.25);
}
.btn-gold:hover,
.btn-gold:focus{
  transform: translateY(-2px);
  filter: saturate(1.05);
  color: #0b0b0b !important;           /* يبقى غامق عند التمرير */
}

/* زر الفضة: نص غامق دائمًا */
.btn-silver{
  background: linear-gradient(145deg,#9aa4ad,#cbd5e1,#94a3b8);
  color: #0b0b0b !important;           /* نص غامق */
  box-shadow: 0 10px 24px rgba(148,163,184,.25);
}
.btn-silver:hover,
.btn-silver:focus{
  transform: translateY(-2px);
  filter: saturate(1.05);
  color: #0b0b0b !important;           /* يبقى غامق عند التمرير */
}

/* أيقونات داخل الأزرار ترث نفس اللون */
.btn i { color: inherit !important; }

</style>

</head>
<body>

<!-- شريط أسعار المعادن -->
<div class="metal-prices-bar">
  <div class="metal-prices-container">
    <div class="metal-price"><i class="fas fa-gem"></i> ذهب 24: <?= $gold24 ?> ر.س/جم</div>
    <div class="metal-price"><i class="fas fa-ring"></i> ذهب 21: <?= $gold21 ?> ر.س/جم</div>
    <div class="metal-price"><i class="fas fa-coins"></i> ذهب 18: <?= $gold18 ?> ر.س/جم</div>
    <div class="metal-price"><i class="fas fa-balance-scale"></i> فضة: <?= $silver ?> ر.س/جم</div>
  </div>
</div>

<header class="header">
  <div class="header-container">
    <div class="logo">
      <a href="index.php" aria-label="العودة للرئيسية">
        <img src="uploads/logo.png" alt="الكندي للذهب" />
      </a>
    </div>

    <ul class="nav-menu" id="mainNav" aria-label="القائمة الرئيسية">
      <li<?= active('index.php', $current) ?>><a href="index.php">الرئيسية</a></li>
      <li<?= active('about.php', $current) ?>><a href="about.php">من نحن</a></li>
	  <li<?= active('index.php', $current) ?>><a href="index.php">ما يميزنا</a></li>
      <li<?= active('gold.php',  $current) ?>><a href="gold.php"> سبائك الذهب</a></li>
      <li<?= active('silver.php',$current) ?>><a href="silver.php"> سبائك الفضة</a></li>
      <li<?= active('silver.php',$current) ?>><a href="silver.php">المدونة</a></li>
      <li<?= active('contact.php',$current) ?>><a href="contact.php">تواصل معنا</a></li>

    </ul>

    <div class="header-icons">
      <?php if (!empty($_SESSION['user_id'])): ?>
        <span class="user-chip">👤 <?= htmlspecialchars($_SESSION['user_name'] ?? 'حسابي') ?></span>
        <a href="logout.php" title="تسجيل الخروج" aria-label="تسجيل الخروج"><i class="fas fa-sign-out-alt"></i></a>
      <?php else: ?>
        <a href="login.php" title="تسجيل الدخول" aria-label="تسجيل الدخول"><i class="fas fa-user"></i></a>
        <a href="register.php" title="إنشاء حساب" aria-label="إنشاء حساب"><i class="fas fa-user-plus"></i></a>
      <?php endif; ?>

      <a href="cart.php" class="cart-btn" title="سلة التسوق" aria-label="سلة التسوق">
        <i class="fas fa-shopping-cart"></i>
        <?php if ($cartCount > 0): ?>
          <span id="cartCount" class="cart-count"><?= (int)$cartCount ?></span>
        <?php endif; ?>
      </a>

      <button class="hamburger" id="hamburgerBtn" aria-label="فتح القائمة"><i class="fas fa-bars"></i></button>
    </div>
  </div>
</header>

<script>
  document.addEventListener("DOMContentLoaded", function () {
    // حركة عدّاد السلة عند التحميل (أو بعد عمليات السلة)
    var badge = document.getElementById("cartCount");
    if (badge) {
      badge.classList.add("animate");
      setTimeout(function(){ badge.classList.remove("animate"); }, 500);
    }
    // قائمة الجوال
    var btn = document.getElementById('hamburgerBtn');
    var nav = document.getElementById('mainNav');
    if (btn && nav) btn.addEventListener('click', function(){ nav.classList.toggle('open'); });
  });
</script>
