<?php
require_once __DIR__ . "/config/db.php";
require_once __DIR__ . "/config/price.php";
include __DIR__ . "/includes/header.php";

// جلب المنتج
$id = $_GET['id'] ?? 0;
$stmt = db()->prepare("SELECT * FROM products WHERE id=? LIMIT 1");
$stmt->execute([$id]);
$p = $stmt->fetch();

if (!$p) {
    echo "<p style='color:red; text-align:center;'>⚠️ المنتج غير موجود</p>";
    include __DIR__ . "/includes/footer.php";
    exit;
}

// جلب الأسعار
$prices = getPrices();

// تحديد المعدن (ذهب أو فضة)
if (isset($p['karat']) && in_array($p['karat'], [24, 21, 18])) {
    $key = "gold_" . $p['karat'];
    $metal = "ذهب عيار " . $p['karat'];
} else {
    $key = "silver";
    $metal = "فضة";
}

// حساب السعر
$price = isset($prices[$key]) ? $prices[$key] * $p['weight'] : 0;

// الوصف
$desc = isset($p['description']) && $p['description'] ? $p['description'] : "لا يوجد وصف متاح";
?>

<section class="featured-products">
  <h2 class="section-title">إتمام الطلب</h2>
  <div class="products-grid">
    <div class="product-card">
      <div class="product-image">
        <img src="uploads/<?= htmlspecialchars($p['image']) ?>" alt="<?= htmlspecialchars($p['name']) ?>">
      </div>
      <div class="product-info">
        <h3 class="product-title"><?= htmlspecialchars($p['name']) ?></h3>
        <p class="product-description"><?= htmlspecialchars($desc) ?></p>
        <ul class="product-features">
          <li>الوزن: <?= $p['weight'] ?> جم</li>
          <li>المعدن: <?= $metal ?></li>
        </ul>
        <div class="product-divider"></div>
        <div class="product-price-container">
          <span class="product-price"><?= number_format($price, 2) ?> ر.س</span>
        </div>

        <!-- نموذج تأكيد الطلب -->
        <form action="order_submit.php" method="post" style="margin-top:20px;">
          <input type="hidden" name="product_id" value="<?= $p['id'] ?>">
          <input type="hidden" name="price" value="<?= $price ?>">
          <button type="submit" class="btn">تأكيد الطلب</button>
        </form>
      </div>
    </div>
  </div>
</section>

<?php include __DIR__ . "/includes/footer.php"; ?>
