<?php
require_once __DIR__ . "/config/db.php";
include __DIR__ . "/includes/header.php";

$id = (int)($_GET['id'] ?? 0);
$stmt = db()->prepare("SELECT * FROM blog_posts WHERE id=? AND status=1 LIMIT 1");
$stmt->execute([$id]);
$post = $stmt->fetch();

function fix_image_url($p){
  $p = trim((string)$p);
  if ($p !== '' && (stripos($p,'http://')===0 || stripos($p,'https://')===0 || stripos($p,'data:')===0)) return $p;
  if ($p !== '' && strpos($p,'/')===false) $p = 'uploads/'.$p;
  $abs = __DIR__ . '/' . ltrim($p,'/');
  return is_file($abs) ? $p : 'assets/img/placeholder-hero.jpg';
}
?>
<style>
/* ===== فرض خط Cairo داخل تفاصيل التدوينة بالكامل ===== */
.post-wrap, .post-wrap * {
  font-family: 'Cairo','Segoe UI',Tahoma,Geneva,Verdana,sans-serif !important;
}

/* تنسيق صفحة التفاصيل */
.post-wrap{width:90%;margin:40px auto}
.post-hero{height:360px;background:#111;border-radius:10px;overflow:hidden;margin-bottom:20px}
.post-hero img{width:100%;height:100%;object-fit:cover}
.post-title{font-size:28px;color:var(--text-color);margin:10px 0}
.post-meta{color:#aaa;font-size:13px;margin-bottom:16px}
.post-summary{color:var(--dark-gray);background:var(--card-color);padding:16px;border-radius:10px;margin-bottom:16px;line-height:1.8}
.post-details{color:var(--text-color);line-height:1.95;background:var(--card-color);padding:18px;border-radius:10px}
.post-details p{margin:0 0 1em}
.post-details ul, .post-details ol{padding-right:22px;margin:0 0 1em}
.post-details h2, .post-details h3{margin:12px 0 8px;color:var(--primary-color)}
</style>

<section class="post-wrap">
  <?php if(!$post): ?>
    <div class="post-details">المقال غير موجود.</div>
  <?php else: ?>
    <div class="post-hero">
      <img src="<?= htmlspecialchars(fix_image_url($post['image'] ?? '')) ?>" alt="<?= htmlspecialchars($post['title']) ?>">
    </div>
    <h1 class="post-title"><?= htmlspecialchars($post['title']) ?></h1>
    <div class="post-meta"><i class="far fa-calendar"></i> <?= date('Y-m-d', strtotime($post['created_at'])) ?></div>

    <?php if(!empty($post['summary'])): ?>
      <div class="post-summary"><?= nl2br(htmlspecialchars($post['summary'])) ?></div>
    <?php endif; ?>

    <div class="post-details">
      <?php
        // إن كانت التفاصيل نصًا عاديًا:
        echo nl2br(htmlspecialchars((string)$post['details']));

        // ملاحظة: لو لاحقًا سمحت بمحتوى HTML ثري من لوحة التحكم،
        // استبدل السطر أعلاه بـ:
        // echo $post['details'];  // مع تأمين/فلترة HTML حسب حاجتك
      ?>
    </div>
  <?php endif; ?>
</section>

<?php include __DIR__ . "/includes/footer.php"; ?>
