<?php
include "../includes/header.php"; 
require_once "../includes/db.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name  = $_POST['name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $password = password_hash($_POST['password'], PASSWORD_BCRYPT);

    // الصورة الشخصية (اختيارية)
    $avatar = "";
    if (!empty($_FILES['avatar']['name'])) {
        $avatar = time() . "_" . $_FILES['avatar']['name'];
        move_uploaded_file($_FILES['avatar']['tmp_name'], "../assets/uploads/" . $avatar);
    }

    $stmt = $pdo->prepare("INSERT INTO users (name, email, phone, password, avatar) VALUES (?,?,?,?,?)");
    $stmt->execute([$name, $email, $phone, $password, $avatar]);

    // حفظ الدخول مباشرة بعد التسجيل
    $_SESSION['user_id'] = $pdo->lastInsertId();
    header("Location: ../user/dashboard.php");
    exit;
}
?>

<section class="container" style="margin-top:40px;">
  <h2 class="section-title">تسجيل حساب جديد</h2>

  <form method="post" enctype="multipart/form-data" style="max-width:600px;margin:auto;background:#121212;padding:20px;border-radius:8px;">
    <label>الاسم:</label>
    <input type="text" name="name" required style="width:100%;padding:10px;margin:6px 0;">

    <label>البريد الإلكتروني:</label>
    <input type="email" name="email" required style="width:100%;padding:10px;margin:6px 0;">

    <label>رقم الجوال:</label>
    <input type="text" name="phone" required style="width:100%;padding:10px;margin:6px 0;">

    <label>كلمة المرور:</label>
    <input type="password" name="password" required style="width:100%;padding:10px;margin:6px 0;">

    <label>الصورة الشخصية (اختياري):</label>
    <input type="file" name="avatar" accept="image/*" style="margin:10px 0;">

    <button type="submit" class="btn">تسجيل</button>
  </form>
</section>

<?php include "../includes/footer.php"; ?>
