<?php
include "../includes/header.php"; 
require_once "../includes/db.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $emailOrPhone = $_POST['email_phone'];
    $password     = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM users WHERE email=? OR phone=? LIMIT 1");
    $stmt->execute([$emailOrPhone, $emailOrPhone]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        header("Location: ../user/dashboard.php");
        exit;
    } else {
        $error = "بيانات الدخول غير صحيحة";
    }
}
?>

<section class="container" style="margin-top:40px;">
  <h2 class="section-title">تسجيل الدخول</h2>

  <?php if (!empty($error)): ?>
    <p style="color:#f44336;"><?= $error; ?></p>
  <?php endif; ?>

  <form method="post" style="max-width:600px;margin:auto;background:#121212;padding:20px;border-radius:8px;">
    <label>البريد الإلكتروني أو الجوال:</label>
    <input type="text" name="email_phone" required style="width:100%;padding:10px;margin:6px 0;">

    <label>كلمة المرور:</label>
    <input type="password" name="password" required style="width:100%;padding:10px;margin:6px 0;">

    <button type="submit" class="btn">دخول</button>
  </form>
</section>

<?php include "../includes/footer.php"; ?>
