<?php
// admin/sliders.php
if (session_status() === PHP_SESSION_NONE) session_start();

require_once "../config/db.php";
require_once "../includes/auth.php";
include "partials/header.php";

// (اختياري) حماية بسيطة: exige login
if (empty($_SESSION['user_id'])) {
  // غيّر المسار حسب نظام الدخول لديك
  // header('Location: ../login.php'); exit;
}

// مسار رفع الصور
$uploadDir = __DIR__ . '/../uploads/';
if (!is_dir($uploadDir)) @mkdir($uploadDir, 0777, true);

// رسائل فلاش
function flash($msg, $type='success'){
  $_SESSION['flash'] = ['msg'=>$msg,'type'=>$type];
}
function show_flash(){
  if (!empty($_SESSION['flash'])) {
    $f = $_SESSION['flash'];
    echo '<div class="flash '.$f['type'].'">'.$f['msg'].'</div>';
    unset($_SESSION['flash']);
  }
}

// تحميل ملف صورة مع إعادة التسمية
function handle_upload($field, $oldFile = null){
  if (empty($_FILES[$field]['name'])) return $oldFile; // لا تغيير
  if (!is_uploaded_file($_FILES[$field]['tmp_name'])) return $oldFile;

  $allowed = ['jpg','jpeg','png','webp'];
  $name = $_FILES[$field]['name'];
  $ext  = strtolower(pathinfo($name, PATHINFO_EXTENSION));
  if (!in_array($ext, $allowed)) {
    flash('صيغة الصورة غير مسموحة. الصيغ المسموحة: jpg, jpeg, png, webp','error');
    return $oldFile;
  }
  $new = 'slider_'.date('Ymd_His').'_'.bin2hex(random_bytes(3)).'.'.$ext;
  global $uploadDir;
  if (!move_uploaded_file($_FILES[$field]['tmp_name'], $uploadDir.$new)) {
    flash('تعذر رفع الصورة.','error');
    return $oldFile;
  }
  // حذف القديمة إن وُجدت
  if ($oldFile && is_file($uploadDir.$oldFile)) @unlink($uploadDir.$oldFile);
  return $new;
}

// عمليات CRUD
$action = $_GET['action'] ?? '';
$id     = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// حذف
if ($action === 'delete' && $id) {
  $stmt = db()->prepare("SELECT image FROM sliders WHERE id=? LIMIT 1");
  $stmt->execute([$id]);
  if ($row = $stmt->fetch()) {
    // احذف الصورة
    if (!empty($row['image']) && is_file($uploadDir.$row['image'])) @unlink($uploadDir.$row['image']);
    db()->prepare("DELETE FROM sliders WHERE id=? LIMIT 1")->execute([$id]);
    flash('تم حذف الشريحة بنجاح.');
  } else {
    flash('الشريحة غير موجودة.','error');
  }
  header('Location: sliders.php'); exit;
}

// تبديل الحالة
if ($action === 'toggle' && $id) {
  db()->prepare("UPDATE sliders SET status = 1 - status WHERE id=?")->execute([$id]);
  flash('تم تبديل حالة الشريحة.');
  header('Location: sliders.php'); exit;
}

// حفظ (إضافة/تعديل)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['do'] ?? '') === 'save') {
  $id          = (int)($_POST['id'] ?? 0);
  $title       = trim($_POST['title'] ?? '');
  $subtitle    = trim($_POST['subtitle'] ?? '');
  $button_text = trim($_POST['button_text'] ?? '');
  $link        = trim($_POST['link'] ?? '');
  $sort        = (int)($_POST['sort'] ?? 0);
  $status      = isset($_POST['status']) ? 1 : 0;

  if ($title === '') {
    flash('العنوان مطلوب.','error');
  } else {
    if ($id) {
      $stmt = db()->prepare("SELECT image FROM sliders WHERE id=? LIMIT 1");
      $stmt->execute([$id]);
      $old = $stmt->fetch();
      $image = handle_upload('image', $old['image'] ?? null);

      $q = "UPDATE sliders SET title=?, subtitle=?, button_text=?, link=?, image=?, sort=?, status=? WHERE id=?";
      db()->prepare($q)->execute([$title,$subtitle,$button_text,$link,$image,$sort,$status,$id]);
      flash('تم تحديث الشريحة بنجاح.');
    } else {
      $image = handle_upload('image', null);
      if (!$image) { flash('الصورة مطلوبة عند إضافة شريحة جديدة.','error'); }
      else {
        $q = "INSERT INTO sliders(title, subtitle, button_text, link, image, sort, status) VALUES(?,?,?,?,?,?,?)";
        db()->prepare($q)->execute([$title,$subtitle,$button_text,$link,$image,$sort,$status]);
        flash('تم إضافة الشريحة بنجاح.');
      }
    }
  }
  header('Location: sliders.php'); exit;
}

// جلب شريحة للتعديل
$edit = null;
if ($action === 'edit' && $id) {
  $stmt = db()->prepare("SELECT * FROM sliders WHERE id=? LIMIT 1");
  $stmt->execute([$id]);
  $edit = $stmt->fetch();
  if (!$edit) { flash('الشريحة غير موجودة.','error'); header('Location: sliders.php'); exit; }
}

// جلب القائمة
$list = db()->query("SELECT * FROM sliders ORDER BY sort, id")->fetchAll();
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>إدارة السلايدر</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<style>
  :root{--ink:#0f172a;--card:#121212;--bg:#0a0a0a;--gold:#D4AF37;--muted:#888;--line:#2a2a2a}
  body{background:#0a0a0a;color:#e0e0e0;font-family:'Cairo','Segoe UI',Tahoma,sans-serif;margin:0;padding:24px}
  a{color:#ffd76a;text-decoration:none}
  .wrap{max-width:1100px;margin:0 auto}
  h1{margin:0 0 18px 0;font-size:26px}
  .bar{display:flex;justify-content:space-between;align-items:center;margin-bottom:16px}
  .btn{background:var(--gold);color:#000;border:0;border-radius:10px;padding:10px 14px;font-weight:700;cursor:pointer}
  .btn.sec{background:#1f2937;color:#fff}
  .table{width:100%;border-collapse:collapse;background:#111;border:1px solid var(--line);border-radius:12px;overflow:hidden}
  .table th,.table td{padding:10px 12px;border-bottom:1px solid var(--line);vertical-align:middle}
  .table th{background:#0f1320;color:#cbd5e1;text-align:right}
  .table tr:hover td{background:#0f0f0f}
  .status{padding:2px 8px;border-radius:999px;font-size:.85rem}
  .on{background:#064e3b;color:#d1fae5}
  .off{background:#4b5563;color:#e5e7eb}
  .flash{margin:12px 0;padding:10px 12px;border-radius:10px}
  .flash.success{background:#052e1b;color:#d1fae5;border:1px solid #065f46}
  .flash.error{background:#3f1d1d;color:#fee2e2;border:1px solid #7f1d1d}
  .grid{display:grid;grid-template-columns:1fr 360px;gap:16px}
  .card{background:#111;border:1px solid var(--line);border-radius:12px;padding:16px}
  .form-row{display:grid;grid-template-columns:140px 1fr;gap:10px;align-items:center;margin-bottom:10px}
  input[type="text"],input[type="number"],input[type="url"],textarea{
    background:#0b0b0b;border:1px solid var(--line);border-radius:10px;padding:10px;color:#e0e0e0;width:100%
  }
  textarea{min-height:90px;resize:vertical}
  .thumb{width:100%;height:180px;background:#222;border-radius:10px;display:flex;align-items:center;justify-content:center;overflow:hidden}
  .thumb img{width:100%;height:100%;object-fit:cover}
  .actions a{margin-inline-start:8px}
  @media (max-width:900px){.grid{grid-template-columns:1fr}}
</style>
</head>
<body>
<div class="wrap">
  <div class="bar">
    <h1>إدارة السلايدر</h1>
    <a class="btn" href="sliders.php?action=add"><i class="fa fa-plus"></i> شريحة جديدة</a>
  </div>
  <?php show_flash(); ?>

  <div class="grid">
    <!-- القائمة -->
    <div class="card">
      <table class="table">
        <thead>
          <tr>
            <th>#</th>
            <th>الصورة</th>
            <th>العنوان</th>
            <th>النص</th>
            <th>زر/رابط</th>
            <th>الترتيب</th>
            <th>الحالة</th>
            <th>إجراءات</th>
          </tr>
        </thead>
        <tbody>
        <?php if ($list): foreach ($list as $row): ?>
          <tr>
            <td><?= (int)$row['id'] ?></td>
            <td style="width:140px">
              <?php if (!empty($row['image'])): ?>
                <img src="../uploads/<?= htmlspecialchars($row['image']) ?>" alt="" style="width:140px;height:70px;object-fit:cover;border-radius:8px;border:1px solid #222">
              <?php else: ?>
                —
              <?php endif; ?>
            </td>
            <td><?= htmlspecialchars($row['title']) ?></td>
            <td style="max-width:260px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis">
              <?= htmlspecialchars($row['subtitle']) ?>
            </td>
            <td>
              <?php if (!empty($row['button_text'])): ?>
                <span class="status on" style="background:#1e3a8a;color:#bfdbfe"><?= htmlspecialchars($row['button_text']) ?></span>
                <?php if (!empty($row['link'])): ?>
                  <a href="../<?= htmlspecialchars($row['link']) ?>" target="_blank" title="فتح الرابط"><i class="fa fa-link"></i></a>
                <?php endif; ?>
              <?php else: ?>—<?php endif; ?>
            </td>
            <td><?= (int)$row['sort'] ?></td>
            <td>
              <span class="status <?= $row['status'] ? 'on':'off' ?>">
                <?= $row['status'] ? 'مفعل' : 'مخفي' ?>
              </span>
            </td>
            <td class="actions">
              <a href="sliders.php?action=edit&id=<?= (int)$row['id'] ?>" title="تعديل"><i class="fa fa-pen"></i></a>
              <a href="sliders.php?action=toggle&id=<?= (int)$row['id'] ?>" title="تبديل الحالة"><i class="fa fa-power-off"></i></a>
              <a href="sliders.php?action=delete&id=<?= (int)$row['id'] ?>" title="حذف" onclick="return confirm('حذف الشريحة نهائيًا؟')"><i class="fa fa-trash"></i></a>
            </td>
          </tr>
        <?php endforeach; else: ?>
          <tr><td colspan="8" style="text-align:center;color:#aaa">لا توجد شرائح بعد.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>

    <!-- النموذج (إضافة/تعديل) -->
    <div class="card">
      <?php
      $isEdit = ($action === 'edit' && $edit);
      ?>
      <h3 style="margin-top:0"><?= $isEdit ? 'تعديل الشريحة' : 'إضافة شريحة' ?></h3>
      <form method="post" enctype="multipart/form-data">
        <input type="hidden" name="do" value="save">
        <input type="hidden" name="id" value="<?= $isEdit ? (int)$edit['id'] : 0 ?>">

        <div class="form-row">
          <label>العنوان *</label>
          <input type="text" name="title" required value="<?= $isEdit ? htmlspecialchars($edit['title']) : '' ?>">
        </div>

        <div class="form-row">
          <label>النص (Subtitle)</label>
          <textarea name="subtitle"><?= $isEdit ? htmlspecialchars($edit['subtitle']) : '' ?></textarea>
        </div>

        <div class="form-row">
          <label>نص الزر</label>
          <input type="text" name="button_text" value="<?= $isEdit ? htmlspecialchars($edit['button_text']) : '' ?>">
        </div>

        <div class="form-row">
          <label>الرابط (مثال: gold.php)</label>
          <input type="text" name="link" value="<?= $isEdit ? htmlspecialchars($edit['link']) : '' ?>">
        </div>

        <div class="form-row">
          <label>الصورة <?= $isEdit ? '(اتركها فارغة للإبقاء على الحالية)' : '*' ?></label>
          <input type="file" name="image" accept=".jpg,.jpeg,.png,.webp">
        </div>

        <?php if ($isEdit && !empty($edit['image'])): ?>
          <div class="thumb" style="margin-bottom:10px">
            <img src="../uploads/<?= htmlspecialchars($edit['image']) ?>" alt="">
          </div>
        <?php endif; ?>

        <div class="form-row">
          <label>الترتيب</label>
          <input type="number" name="sort" value="<?= $isEdit ? (int)$edit['sort'] : 0 ?>">
        </div>

        <div class="form-row">
          <label>مفعل؟</label>
          <input type="checkbox" name="status" <?= $isEdit ? ($edit['status'] ? 'checked':'') : 'checked' ?>>
        </div>

        <div class="form-row" style="grid-template-columns:1fr">
          <button class="btn" type="submit"><i class="fa fa-save"></i> حفظ</button>
          <?php if ($isEdit): ?>
            <a class="btn sec" href="sliders.php" style="margin-top:8px"><i class="fa fa-rotate-left"></i> إلغاء التعديل</a>
          <?php endif; ?>
        </div>
      </form>
    </div>
  </div>

  <p style="margin-top:16px;color:#9aa7b1">
    تلميح: يُفضّل استخدام صور عريضة (1920×800 تقريبًا) بصيغة WebP لتسريع التحميل. تُحفظ في مجلد <code>uploads/</code>.
  </p>
</div>
</body>
</html>
<?php include "partials/footer.php"; ?>
