<?php
require_once "../config/db.php";
require_once "../includes/auth.php";
include "partials/header.php";
// جلب البيانات الحالية
$settings = $pdo->query("SELECT * FROM site_settings LIMIT 1")->fetch();
$banks    = $pdo->query("SELECT * FROM bank_accounts")->fetchAll();

// عند الحفظ
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $site_name = $_POST['site_name'];

    // رفع الشعار
    $logo = $settings['logo'] ?? '';
    if (!empty($_FILES['logo']['name'])) {
        $logo = "logo_" . time() . "." . pathinfo($_FILES['logo']['name'], PATHINFO_EXTENSION);
        move_uploaded_file($_FILES['logo']['tmp_name'], "../assets/images/" . $logo);
    }

    // رفع الفافيكون
    $favicon = $settings['favicon'] ?? '';
    if (!empty($_FILES['favicon']['name'])) {
        $favicon = "favicon_" . time() . "." . pathinfo($_FILES['favicon']['name'], PATHINFO_EXTENSION);
        move_uploaded_file($_FILES['favicon']['tmp_name'], "../assets/images/" . $favicon);
    }

    // تحديث الإعدادات
    if ($settings) {
        $stmt = $pdo->prepare("UPDATE site_settings SET site_name=?, logo=?, favicon=? WHERE id=?");
        $stmt->execute([$site_name, $logo, $favicon, $settings['id']]);
    } else {
        $stmt = $pdo->prepare("INSERT INTO site_settings (site_name, logo, favicon) VALUES (?,?,?)");
        $stmt->execute([$site_name, $logo, $favicon]);
    }

    header("Location: settings.php?saved=1");
    exit;
}
?>

<section class="card">
  <h2>إعدادات الموقع</h2>
  <form method="post" enctype="multipart/form-data">
    <label>اسم الموقع:</label>
    <input type="text" name="site_name" value="<?= e($settings['site_name'] ?? '') ?>" required style="width:100%;padding:8px;margin:6px 0;">

    <label>الشعار (Logo):</label><br>
    <?php if (!empty($settings['logo'])): ?>
      <img src="../assets/images/<?= e($settings['logo']); ?>" alt="Logo" style="height:50px;"><br>
    <?php endif; ?>
    <input type="file" name="logo">

    <label>الأيقونة (Favicon):</label><br>
    <?php if (!empty($settings['favicon'])): ?>
      <img src="../assets/images/<?= e($settings['favicon']); ?>" alt="Favicon" style="height:32px;"><br>
    <?php endif; ?>
    <input type="file" name="favicon">

    <button type="submit" class="btn" style="margin-top:15px;">حفظ</button>
  </form>
</section>

<section class="card">
  <h2>الحسابات البنكية</h2>
  <table>
    <tr>
      <th>البنك</th>
      <th>رقم الحساب</th>
      <th>الآيبان</th>
      <th>صاحب الحساب</th>
    </tr>
    <?php foreach($banks as $b): ?>
    <tr>
      <td><?= e($b['bank_name']); ?></td>
      <td><?= e($b['account_number']); ?></td>
      <td><?= e($b['iban']); ?></td>
      <td><?= e($b['account_holder']); ?></td>
    </tr>
    <?php endforeach; ?>
  </table>
  <a href="settings_bank_add.php" class="btn" style="margin-top:10px;">إضافة حساب جديد</a>
</section>

<?php include __DIR__ . "/partials/footer.php"; ?>
