<?php
require_once "../config/db.php";
require_once "../includes/auth.php";
include "partials/header.php";

// جلب الصفحات من جدول seo_pages
$pages = $pdo->query("SELECT * FROM seo_pages ORDER BY id ASC")->fetchAll();
?>

<section class="card">
  <h2>إدارة SEO</h2>
  <table>
    <tr>
      <th>الصفحة</th>
      <th>العنوان</th>
      <th>الوصف</th>
      <th>إجراءات</th>
    </tr>
    <?php foreach($pages as $p): ?>
    <tr>
      <td><?= e($p['page']); ?></td>
      <td><?= e(mb_strimwidth($p['title'],0,30,'...')); ?></td>
      <td><?= e(mb_strimwidth($p['description'],0,40,'...')); ?></td>
      <td>
        <a href="seo_edit.php?id=<?= $p['id']; ?>" class="btn">تعديل</a>
      </td>
    </tr>
    <?php endforeach; ?>
  </table>
</section>

<?php include __DIR__ . "/partials/footer.php"; ?>
